% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/args_classes.R
\name{insilicosystemargs}
\alias{insilicosystemargs}
\title{Constructor function for the \code{insilicosystemsargs} class.}
\usage{
insilicosystemargs(
  G = 10,
  ploidy = 2,
  PC.p = 0.7,
  PC.TC.p = NULL,
  PC.TL.p = NULL,
  PC.RD.p = NULL,
  PC.PD.p = NULL,
  PC.PTM.p = NULL,
  PC.MR.p = NULL,
  NC.TC.p = NULL,
  NC.TL.p = NULL,
  NC.RD.p = NULL,
  NC.PD.p = NULL,
  NC.PTM.p = NULL,
  TC.pos.p = 0.5,
  TL.pos.p = 0.5,
  PTM.pos.p = 0.5,
  basal_transcription_rate_samplingfct = NULL,
  basal_translation_rate_samplingfct = NULL,
  basal_RNAlifetime_samplingfct = NULL,
  basal_protlifetime_samplingfct = NULL,
  TC.PC.outdeg.distr = "powerlaw",
  TC.NC.outdeg.distr = "powerlaw",
  TC.PC.outdeg.exp = 3,
  TC.NC.outdeg.exp = 5,
  TC.PC.indeg.distr = "powerlaw",
  TC.NC.indeg.distr = "powerlaw",
  TC.PC.autoregproba = 0.2,
  TC.NC.autoregproba = 0,
  TC.PC.twonodesloop = FALSE,
  TC.NC.twonodesloop = FALSE,
  TCbindingrate_samplingfct = NULL,
  TCunbindingrate_samplingfct = NULL,
  TCfoldchange_samplingfct = NULL,
  TL.PC.outdeg.distr = "powerlaw",
  TL.NC.outdeg.distr = "powerlaw",
  TL.PC.outdeg.exp = 4,
  TL.NC.outdeg.exp = 6,
  TL.PC.indeg.distr = "powerlaw",
  TL.NC.indeg.distr = "powerlaw",
  TL.PC.autoregproba = 0.2,
  TL.NC.autoregproba = 0,
  TL.PC.twonodesloop = FALSE,
  TL.NC.twonodesloop = FALSE,
  TLbindingrate_samplingfct = NULL,
  TLunbindingrate_samplingfct = NULL,
  TLfoldchange_samplingfct = NULL,
  RD.PC.outdeg.distr = "powerlaw",
  RD.NC.outdeg.distr = "powerlaw",
  RD.PC.outdeg.exp = 4,
  RD.NC.outdeg.exp = 6,
  RD.PC.indeg.distr = "powerlaw",
  RD.NC.indeg.distr = "powerlaw",
  RD.PC.autoregproba = 0.2,
  RD.NC.autoregproba = 0,
  RD.PC.twonodesloop = FALSE,
  RD.NC.twonodesloop = FALSE,
  RDregrate_samplingfct = NULL,
  PD.PC.outdeg.distr = "powerlaw",
  PD.NC.outdeg.distr = "powerlaw",
  PD.PC.outdeg.exp = 4,
  PD.NC.outdeg.exp = 6,
  PD.PC.indeg.distr = "powerlaw",
  PD.NC.indeg.distr = "powerlaw",
  PD.PC.autoregproba = 0.2,
  PD.NC.autoregproba = 0,
  PD.PC.twonodesloop = FALSE,
  PD.NC.twonodesloop = FALSE,
  PDregrate_samplingfct = NULL,
  PTM.PC.outdeg.distr = "powerlaw",
  PTM.NC.outdeg.distr = "powerlaw",
  PTM.PC.outdeg.exp = 4,
  PTM.NC.outdeg.exp = 6,
  PTM.PC.indeg.distr = "powerlaw",
  PTM.NC.indeg.distr = "powerlaw",
  PTM.PC.autoregproba = 0.2,
  PTM.NC.autoregproba = 0,
  PTM.PC.twonodesloop = FALSE,
  PTM.NC.twonodesloop = FALSE,
  PTMregrate_samplingfct = NULL,
  regcomplexes = "prot",
  regcomplexes.p = 0.3,
  regcomplexes.size = 2,
  complexesformationrate_samplingfct = NULL,
  complexesdissociationrate_samplingfct = NULL
)
}
\arguments{
\item{G}{Integer. Number of genes in the system. Default value is 10.}

\item{ploidy}{Numeric. The ploidy of the system, i.e. how many copies of each gene are present in the system. Default value is 2.}

\item{PC.p}{Numeric. Probability of each gene to be a protein-coding gene. Default value is 0.7.}

\item{PC.TC.p}{Numeric. Probability of a protein-coding gene to be a regulator of transcription. Default value is 0.4 (see details).}

\item{PC.TL.p}{Numeric. Probability of a protein-coding gene to be a regulator of translation. Default value is 0.3 (see details).}

\item{PC.RD.p}{Numeric. Probability of a protein-coding gene to be a regulator of RNA decay. Default value is 0.1 (see details).}

\item{PC.PD.p}{Numeric. Probability of a protein-coding gene to be a regulator of protein decay. Default value is 0.1 (see details).}

\item{PC.PTM.p}{Numeric. Probability of a protein-coding gene to be a regulator of protein post-translational modification. Default value is 0.05 (see details).}

\item{PC.MR.p}{Numeric. Probability of a protein-coding gene to be a metabolic enzyme. Default value is 0.05 (see details).}

\item{NC.TC.p}{Numeric. Probability of a noncoding gene to be a regulator of transcription. Default value is 0.3 (see details).}

\item{NC.TL.p}{Numeric. Probability of a noncoding gene to be a regulator of translation. Default value is 0.3 (see details).}

\item{NC.RD.p}{Numeric. Probability of a noncoding gene to be a regulator of RNA decay. Default value is 0.3 (see details).}

\item{NC.PD.p}{Numeric. Probability of a noncoding gene to be a regulator of protein decay. Default value is 0.05 (see details).}

\item{NC.PTM.p}{Numeric. Probability of a noncoding gene to be a regulator of protein post-translational modification. Default value is 0.05 (see details).}

\item{TC.pos.p}{Numeric. Probability of a regulation targeting gene transcription to be positive. Default value is 0.5.}

\item{TL.pos.p}{Numeric. Probability of a regulation targeting gene translation to be positive. Default value is 0.5.}

\item{PTM.pos.p}{Numeric. Probability of a regulation targeting protein post-translational modification to be positive (i.e the targeted protein
is transformed into its modified form, as opposed to the modified protein being transformed back into its original form). Default value is 0.5.}

\item{basal_transcription_rate_samplingfct}{Function from which the transcription rates of genes are sampled (input x is the required sample size). Default value is
a function returning \code{(10^v)/3600}, with \code{v} a vector of size x sampled from a normal distribution with mean of 3 and sd of 0.5.}

\item{basal_translation_rate_samplingfct}{Function from which the translation rates of genes are sampled (input x is the required sample size). Default value is
a function returning \code{(10^v)/3600}, with \code{v} a vector of size x sampled from a normal distribution with mean of 2.146 and sd of 0.7.}

\item{basal_RNAlifetime_samplingfct}{Function from which the transcript lifetimes are sampled (input x is the required sample size). Default value is
a function returning \code{(10^v)*3600}, with \code{v} a vector of size x sampled from a normal distribution with mean of 0.95 and sd of 0.2.}

\item{basal_protlifetime_samplingfct}{Function from which the protein lifetime are sampled (input x is the required sample size). Default value is
a function returning \code{(10^v)*3600}, with \code{v} a vector of size x sampled from a normal distribution with mean of 1.3 and sd of 0.4.}

\item{TC.PC.outdeg.distr}{Form of the distribution of the number of targets (out-degree) of protein regulators in the transcription regulation graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{TC.NC.outdeg.distr}{Form of the distribution of the number of targets (out-degree) of noncoding regulators in the transcription regulation graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{TC.PC.outdeg.exp}{Numeric. Exponent of the distribution for the out-degree of the protein regulators in the transcription regulation graph. Default value is 3.}

\item{TC.NC.outdeg.exp}{Numeric. Exponent of the distribution for the out-degree of the noncoding regulators in the transcription regulation graph. Default value is 5.}

\item{TC.PC.indeg.distr}{Type of preferential attachment for the targets of protein regulators in the transcription regulation graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{TC.NC.indeg.distr}{Type of preferential attachment for the targets of noncoding regulators in the transcription regulation graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{TC.PC.autoregproba}{Numeric. Probability of protein regulators to perform autoregulation in the transcription regulation graph. Default value is 0.2.}

\item{TC.NC.autoregproba}{Numeric. Probability of noncoding regulators to perform autoregulation in the transcription regulation graph. Default value is 0.}

\item{TC.PC.twonodesloop}{Logical. Are 2-nodes loops authorised in the transcription regulation graph with protein regulators? Default value is FALSE.}

\item{TC.NC.twonodesloop}{Logical. Are 2-nodes loops authorised in the transcription regulation graph with noncoding regulators? Default value is FALSE.}

\item{TCbindingrate_samplingfct}{Function from which the binding rates of transcription regulators on their targets are sampled (input \code{means} is a vector of length equal to the required sample size, giving for each
edge (regulatory interaction) for which a binding rate is being sampled the value of the sampled unbinding rate divided by the steady-state abundance of the regulator
in absence of any regulation in the system). Default value is a function returning \code{10^v}, where \code{v} is a vector with the same length as \code{means} whose elements are sampled
from a truncated normal distribution with mean equal to the log10 of the corresponding element in \code{means}, and sd = 0.1, the minimum authorised value being the log10 of the corresponding element in \code{means}.}

\item{TCunbindingrate_samplingfct}{Function from which the unbinding rates of transcription regulators from their target are sampled (input x is the required sample size). Default value is
a function returning \code{10^v}, with \code{v} a vector of size x sampled from a normal distribution with mean of -3 and sd of 0.2.}

\item{TCfoldchange_samplingfct}{Function from which the transcription fold change induced by a bound regulator is sampled (input x is the required sample size). Default value is
a truncated normal distribution with a mean of 3, sd of 10 and minimum authorised value of 1.5.}

\item{TL.PC.outdeg.distr}{Form of the distribution of the number of targets (out-degree) of protein regulators in the translation regulation graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{TL.NC.outdeg.distr}{Form of the the distribution of the number of targets (out-degree) of noncoding regulators in the translation regulation graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{TL.PC.outdeg.exp}{Numeric. Exponent of the distribution for the out-degree of the protein regulators in the translation regulation graph. Default value is 4.}

\item{TL.NC.outdeg.exp}{Numeric. Exponent of the distribution for the out-degree of the noncoding regulators in the translation regulation graph. Default value is 6.}

\item{TL.PC.indeg.distr}{Type of preferential attachment for the targets of protein regulators in the translation regulation graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{TL.NC.indeg.distr}{Type of preferential attachment for the targets of noncoding regulators in the translation regulation graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{TL.PC.autoregproba}{Numeric. Probability of protein regulators to perform autoregulation in the translation regulation graph. Default value is 0.2.}

\item{TL.NC.autoregproba}{Numeric. Probability of noncoding regulators to perform autoregulation in the translation regulation graph. Default value is 0.}

\item{TL.PC.twonodesloop}{Logical. Are 2-nodes loops authorised in the translation regulation graph with protein regulators? Default value is FALSE.}

\item{TL.NC.twonodesloop}{Logical. Are 2-nodes loops authorised in the translation regulation graph with noncoding regulators? Default value is FALSE.}

\item{TLbindingrate_samplingfct}{Function from which the binding rate of translation regulators on target are sampled (input \code{means} is a vector of length equal to the required sample size, giving for each
edge (regulatory interaction) for which a binding rate is being sampled the value of the sampled unbinding rate divided by the steady-state abundance of the regulator
in absence of any regulation in the system). Default value is a function returning \code{10^v}, where \code{v} is a vector with the same length as \code{means} whose elements are sampled
from a truncated normal distribution with mean equal to the log10 of the corresponding element in \code{means}, and sd = 0.1, the minimum authorised value being the log10 of the corresponding element in \code{means}.}

\item{TLunbindingrate_samplingfct}{Function from which the unbinding rate of translation regulators from target are sampled (input x is the required sample size). Default value is
a function returning \code{10^v}, with \code{v} a vector of size x sampled from a normal distribution with mean of -3 and sd of 0.2.}

\item{TLfoldchange_samplingfct}{Function from which the translation fold change induced by a bound regulator are sampled (input x is the required sample size). Default value is
a truncated normal distribution with a mean of 3, sd of 10 and minimum authorised value of 1.5.}

\item{RD.PC.outdeg.distr}{Form of the distribution of the number of targets (out-degree) of protein regulators in the RNA decay regulation graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{RD.NC.outdeg.distr}{Form of the the distribution of the number of targets (out-degree) of noncoding regulators in the RNA decay regulation graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{RD.PC.outdeg.exp}{Numeric. Exponent of the distribution for the out-degree of the protein regulators in the RNA decay regulation graph. Default value is 4.}

\item{RD.NC.outdeg.exp}{Numeric. Exponent of the distribution for the out-degree of the noncoding regulators in the RNA decay regulation graph. Default value is 6.}

\item{RD.PC.indeg.distr}{Type of preferential attachment for the targets of protein regulators in the RNA decay graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{RD.NC.indeg.distr}{Type of preferential attachment for the targets of noncoding regulators in the RNA decay graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{RD.PC.autoregproba}{Numeric. Probability of protein regulators to perform autoregulation in the RNA decay regulation graph. Default value is 0.2.}

\item{RD.NC.autoregproba}{Numeric. Probability of noncoding regulators to perform autoregulation in the RNA decay regulation graph. Default value is 0.}

\item{RD.PC.twonodesloop}{Logical. Are 2-nodes loops authorised in the RNA decay regulation graph with protein regulators? Default value is FALSE.}

\item{RD.NC.twonodesloop}{Logical. Are 2-nodes loops authorised in the RNA decay regulation graph with noncoding regulators? Default value is FALSE.}

\item{RDregrate_samplingfct}{Function from which the RNA decay rates of targets of RNA decay regulators are sampled (input x is the required sample size). Default value is
a function returning \code{10^v}, with \code{v} a vector of size x sampled from a normal distribution with mean of -5 and sd of 1.5.}

\item{PD.PC.outdeg.distr}{Form of the distribution of the number of targets (out-degree) of protein regulators in the protein decay regulation graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{PD.NC.outdeg.distr}{Form of the the distribution of the number of targets (out-degree) of noncoding regulators in the protein decay regulation graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{PD.PC.outdeg.exp}{Numeric. Exponent of the distribution for the out-degree of the protein regulators in the protein decay regulation graph. Default value is 4.}

\item{PD.NC.outdeg.exp}{Numeric. Exponent of the distribution for the out-degree of the noncoding regulators in the protein decay regulation graph. Default value is 6.}

\item{PD.PC.indeg.distr}{Type of preferential attachment for the targets of protein regulators in the protein decay regulation graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{PD.NC.indeg.distr}{Type of preferential attachment for the targets of noncoding regulators in the protein decay graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{PD.PC.autoregproba}{Numeric. Probability of protein regulators to perform autoregulation in the protein decay regulation graph. Default value is 0.2.}

\item{PD.NC.autoregproba}{Numeric. Probability of noncoding regulators to perform autoregulation in the protein decay regulation graph. Default value is 0.}

\item{PD.PC.twonodesloop}{Logical. Are 2-nodes loops authorised in the protein decay graph with protein regulators in the protein decay regulation graph? Default value is FALSE.}

\item{PD.NC.twonodesloop}{Logical. Are 2-nodes loops authorised in the protein decay graph with noncoding regulators in the protein decay regulation graph? Default value is FALSE.}

\item{PDregrate_samplingfct}{Function from which the protein decay rates of targets of protein decay regulators are sampled (input x is the required sample size).  Default value is
a function returning \code{10^v}, with \code{v} a vector of size x sampled from a normal distribution with mean of -5 and sd of 1.5.}

\item{PTM.PC.outdeg.distr}{Form of the distribution of the number of targets (out-degree) of protein regulators in the post-translational modification regulation graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{PTM.NC.outdeg.distr}{Form of the the distribution of the number of targets (out-degree) of noncoding regulators in the post-translational modification regulation graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{PTM.PC.outdeg.exp}{Numeric. Exponent of the distribution for the out-degree of the protein regulators in the protein post-translational modification graph. Default value is 4.}

\item{PTM.NC.outdeg.exp}{Numeric. Exponent of the distribution for the out-degree of the noncoding regulators in the protein post-translational modification graph. Default value is 6.}

\item{PTM.PC.indeg.distr}{Type of preferential attachment for the targets of protein regulators in the protein post-translational modification graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{PTM.NC.indeg.distr}{Type of preferential attachment for the targets of noncoding regulators in the protein post-translational modification graph; can be either "powerlaw" or "exponential". Default value is "powerlaw".}

\item{PTM.PC.autoregproba}{Numeric. Probability of protein regulators to perform autoregulation. Default value is 0.2.}

\item{PTM.NC.autoregproba}{Numeric. Probability of noncoding regulators to perform autoregulation. Default value is 0.}

\item{PTM.PC.twonodesloop}{Logical. Are 2-nodes loops authorised in the protein post-translational modification graph with protein regulators? Default value is FALSE.}

\item{PTM.NC.twonodesloop}{Logical. Are 2-nodes loops authorised in the protein post-translational modification graph with noncoding regulators? Default value is FALSE.}

\item{PTMregrate_samplingfct}{Function from which the protein transformation rates of targets of post-translational modification regulators are sampled (input x is the required sample size). Default value is
a function returning \code{10^v}, with \code{v} a vector of size x sampled from a normal distribution with mean of -5 and sd of 1.5.}

\item{regcomplexes}{Can the regulators controlling a common target form regulatory complexes in the different regulatory graphs? Can be 'none', 'prot' (only protein can form regulatory complexes) or 'both'
(both regulatory RNAs and proteins can form regulatory complexes). Default value is "prot".}

\item{regcomplexes.p}{Numeric. Probability that regulators controlling a common target form regulatory complexes; ignore if \code{regcomplexes} = 'none'. Default value is 0.3.}

\item{regcomplexes.size}{Integer. Number of components of a regulatory complex; ignore if \code{regcomplexes} = 'none'. Default value is 2.}

\item{complexesformationrate_samplingfct}{Function from which the formation rate of regulatory complexes are sampled (input x is the required sample size). Default value is
a function returning \code{10^v}, with \code{v} a vector of size x sampled from a normal distribution with mean of -3 and sd of 0.7.}

\item{complexesdissociationrate_samplingfct}{Function from which the dissociation rate of regulatory complexes are sampled (input x is the required sample size). Default value is
a function returning \code{10^v}, with \code{v} a vector of size x sampled from a normal distribution with mean of 3 and sd of 0.9.}
}
\value{
An object of the class \code{insilicosystemargs}, that is a named list of the different parameters.
}
\description{
Constructor function for the \code{insilicosystemsargs} class, with default values for the parameters if not provided by the user.
}
\details{
For the protein-coding (and non-coding) biological function ratios (i.e. PC.TC.p, PC.TL.p, etc): if none of the ratios are provided,
then they are set to their default values. Otherwise, if at least one value among the 6 (5 for noncoding genes) is set by the user:
\itemize{
\item if the sum of the provided values is 1 or more: the non-specified values are set to 0, and the specified values are normalised
such that their sum is 1.
\item if the sum of the provided values is less than 1: the non-specified values are set such that the sum of all ratios equals 1.
}
Example: if the user sets PC.TC.p to 1 and PC.TL.p to 0.6, but does not provide any values for the other ratios,
then PC.TC.p is set to 1/(1+0.6)=0.625, PC.TL.p to 0.6/(1+0.6)=0.375, and PC.RD.p, PC.PD.p, PC.PTM.p and PC.MR.p are all set to 0.
Accordingly, if the user only sets NC.TC.p to 0.6, then NC.TL.p, NC.RD.p, NC.PD.p and NC.PTM.p are all set to 0.1.
}
\examples{
sysargs = insilicosystemargs(G = 15, PC.p = 0.2,
 basal_transcription_rate_samplingfct = function(x){runif(x, 0.1, 0.2)})
}
