% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation-class.R
\docType{class}
\name{Simulation-class}
\alias{Simulation-class}
\title{An S4 class representing a simulation.}
\description{
A simulation is a set of references to simulator objects that have been
saved to file.  The DrawsRef, OutputRef, and EvalsRef objects are organized
by model into separate lists.
}
\details{
When a reference ref is added to a simulation sim, ref@dir is changed so
that the referenced file is located at file.path(sim@dir, ref@dir).
}
\section{Slots}{

\describe{
\item{\code{name}}{a short name identifier.  Must be an alphanumeric (but can also
have - or _ within}

\item{\code{label}}{a longer, human readable label that can have other characters
such as spaces, hyphens, etc.}

\item{\code{dir}}{name of the directory where directory named "files" exists.}

\item{\code{model_refs}}{a list of \code{\linkS4class{ModelRef}} objects}

\item{\code{draws_refs}}{a list of lists of \code{\linkS4class{DrawsRef}} objects}

\item{\code{output_refs}}{a list of lists of \code{\linkS4class{OutputRef}} objects}

\item{\code{evals_refs}}{a list of lists of \code{\linkS4class{EvalsRef}} objects}
}}

