% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotextra.R
\name{tidy_beta}
\alias{tidy_beta}
\alias{abs_sigma}
\title{Tidy Functions to make plotting easy}
\usage{
tidy_beta(obj)

abs_sigma(sigma_df)
}
\arguments{
\item{obj}{A Simrel Object}

\item{sigma_df}{A tidy covariance data frame generated by tidy_sigma function}
}
\value{
A tibble with three columns: Predictor, Response and BetaCoef

Another data.frame (tibble) of same dimension with absolute covarinace scaled by overall maximum absolute values
}
\description{
Tidy Functions to make plotting easy

Absolute value of sigma scaled by the overall maximum absolute value
}
\examples{
sobj <- multisimrel()
beta_df <- tidy_beta(sobj)
beta_df
sobj <- multisimrel()
sobj \%>\% 
    cov_mat("zy") \%>\% 
    tidy_sigma() \%>\% 
    abs_sigma()
}
