% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_hbar_fun.R
\name{ggplot_hbar}
\alias{ggplot_hbar}
\title{Horizontal bar ggplot.}
\usage{
ggplot_hbar(data, x_var, y_var, hover_var = NULL, x_scale_zero = TRUE,
  x_scale_trans = "identity", y_scale_rev = FALSE, pal = NULL,
  width = 0.75, title = "[Title]", subtitle = NULL,
  x_title = "[X title]", y_title = "[Y title]", caption = "",
  font_family = "Helvetica", font_size_title = NULL,
  font_size_body = NULL, wrap_title = 70, wrap_subtitle = 80,
  wrap_x_title = 50, wrap_y_title = 50, wrap_y_label = 50,
  wrap_caption = 80, isMobile = FALSE)
}
\arguments{
\item{data}{A tibble or dataframe. Required input.}

\item{x_var}{Unquoted numeric variable to be on the x axis. Required input.}

\item{y_var}{Unquoted categorical variable to be on the y axis. Required input.}

\item{hover_var}{Unquoted variable to be an additional hover variable for when used inside plotly::ggplotly(). Defaults to NULL.}

\item{x_scale_zero}{TRUE or FALSE whether the minimum of the x scale is zero. Defaults to TRUE.}

\item{x_scale_trans}{A string specifying a transformation for the x axis scale. Defaults to "identity".}

\item{y_scale_rev}{TRUE or FALSE of whether bar order from top to bottom is reversed from default. Defaults to FALSE.}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects the Stats NZ palette.}

\item{width}{Width of bars. Defaults to 0.75.}

\item{title}{Title string. Defaults to [Title].}

\item{subtitle}{Subtitle string. Defaults to [Subtitle].}

\item{x_title}{X axis title string. Defaults to [X title].}

\item{y_title}{Y axis title string. Defaults to [Y title].}

\item{caption}{Caption title string. Defaults to NULL.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{wrap_title}{Number of characters to wrap the title to. Defaults to 70. Not applicable where isMobile equals TRUE.}

\item{wrap_subtitle}{Number of characters to wrap the subtitle to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{wrap_x_title}{Number of characters to wrap the x title to. Defaults to 50. Not applicable where isMobile equals TRUE.}

\item{wrap_y_title}{Number of characters to wrap the y title to. Defaults to 50. Not applicable where isMobile equals TRUE.}

\item{wrap_y_label}{Number of characters to wrap the y labels to. Defaults to 50. Not applicable where isMobile equals TRUE.}

\item{wrap_caption}{Number of characters to wrap the caption to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{isMobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE. In a shinyapp, isMobile should be specified as input$isMobile.}
}
\value{
A ggplot object.
}
\description{
Horizontal bar ggplot that is not coloured and not facetted.
}
\examples{
plot_data <- ggplot2::diamonds \%>\%
  dplyr::mutate(cut = stringr::str_to_sentence(cut)) \%>\%
  dplyr::group_by(cut) \%>\%
  dplyr::summarise(average_price = mean(price)) \%>\%
  dplyr::mutate(average_price_thousands = round(average_price / 1000, 1)) 

plot <- ggplot_hbar(data = plot_data, x_var = average_price_thousands, y_var = cut,
   title = "Average diamond price by cut",
   x_title = "Average price ($US thousands)",
   y_title = "Cut")

plot

plotly::ggplotly(plot, tooltip = "text")
}
