% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimplaceWrapperHelper.R
\name{findFirstSimplaceInstallation}
\alias{findFirstSimplaceInstallation}
\title{Search for simplace installation and returns first match}
\usage{
findFirstSimplaceInstallation(
  directories = c(),
  tryStandardDirs = TRUE,
  simulationsDir = "simplace_run",
  ignoreSimulationsDir = FALSE
)
}
\arguments{
\item{directories}{a list of additional directories where to look -}

\item{tryStandardDirs}{whether to check for typical installation directories (default)}

\item{simulationsDir}{directory that contains user simulations (e.g. simplace_run)}

\item{ignoreSimulationsDir}{don't check for the simulation dir}
}
\value{
matching directory/ies as character vector
}
\description{
Checks directories if they contain simplace_core, simplace_modules and 
optionally simplace_run (or a data directory given by the user) and returns
the first match.
There is no check whether the installation is really working.
}
\details{
Beside the checks for some standard directories (like home directory, current
working dir and drives c: to g:) and their subdirectories (workspace, simplace,
java/simplace) the user can give a vector of additional directories. Directories 
given by the user are checked first.
}
