% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_glm_func.r
\name{sim_glm_single}
\alias{sim_glm_single}
\title{Simulation single level logistic regression model}
\usage{
sim_glm_single(fixed, fixed_param, cov_param, n, data_str, cor_vars = NULL,
  fact_vars = list(NULL), contrasts = NULL, outcome_type,
  knot_args = list(NULL), ...)
}
\arguments{
\item{fixed}{One sided formula for fixed effects in the simulation.
To suppress intercept add -1 to formula.}

\item{fixed_param}{Fixed effect parameter values (i.e. beta weights).
Must be same length as fixed.}

\item{cov_param}{List of arguments to pass to the continuous generating 
function, must be the same order as the variables specified in fixed. 
This list does not include intercept, time, factors, or 
interactions. Required arguments include:
\itemize{
  \item dist_fun: This is a quoted R distribution function.
  \item var_type: This is the level of variable to generate. Must be 
    'single'.
    Must be same order as fixed formula above.
}
Optional arguments to the distribution functions are in a nested list,
 see the examples or vignettes for example code.}

\item{n}{Cluster sample size.}

\item{data_str}{Type of data. Must be "cross", "long", or "single".}

\item{cor_vars}{A vector of correlations between variables.}

\item{fact_vars}{A nested list of factor, categorical, or ordinal variable 
   specification, each list must include:
\itemize{
     \item numlevels = Number of levels for ordinal or factor variables.
     \item var_type = Must be 'single', 'lvl1', 'lvl2', or 'lvl3'.
 }
 Optional arguments include:
 \itemize{
     \item replace
     \item prob
     \item value.labels
 }
  See also \code{\link{sample}} for use of these optional arguments.}

\item{contrasts}{An optional list that specifies the contrasts to be used 
for factor variables (i.e. those variables with .f or .c). 
See \code{\link{contrasts}} for more detail.}

\item{outcome_type}{A vector specifying the type of outcome, must be either
logistic or poisson. Logitstic outcome will be 0/1 and poisson outcome will
be counts.}

\item{knot_args}{A nested list of named knot arguments. See \code{\link{sim_knot}} 
for more details. Arguments must include:
  \itemize{
    \item var
    \item knot_locations
  }}

\item{...}{Not currently used.}
}
\description{
Takes simulation parameters as inputs and returns simulated data.
}
\details{
Simulates data for the simple logistic regression models.  Returns 
a data frame with ID variables, fixed effects, and many other variables
to help when running simulation studies.
}
\examples{
# generating parameters for single level regression
set.seed(2)
fixed <- ~1 + act + diff + numCourse + act:numCourse
fixed_param <- c(0.1, -0.2, 0.15, 0.5, -0.02)
cov_param <- list(dist_fun = c('rnorm', 'rnorm', 'rnorm'),
   var_type = c("single", "single", "single"),
   opts = list(list(mean = 0, sd = 4),
   list(mean = 0, sd = 3),
   list(mean = 0, sd = 3)))
n <- 150
temp_single <- sim_glm(fixed = fixed, fixed_param = fixed_param, 
  cov_param = cov_param, n = n, data_str = "single", 
  outcome_type = 'logistic')
  
}
