% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distributions.R
\name{rcategor}
\alias{rcategor}
\title{Categorical Node Distribution (Factor)}
\usage{
rcategor(n, probs)
}
\arguments{
\item{n}{Sample size.}

\item{probs}{Either a vector or a matrix of success probabilities. When \code{probs} is a vector, \code{n} identically distributed random categorical variables are generated with categories: 1, 2, ..., length(probs)+1. When \code{probs} is a matrix, the categorical probabilities of the \code{k}th sample are determined by the \code{k}th row of \code{probs} matrix, i.e., \code{probs[k,]}.}
}
\value{
A factor of length \code{n} with levels: \code{1,2, ...,ncol(probs)+1}.
}
\description{
Matrix version of the categorical distribution. The argument \code{probs} can be a matrix of n rows, specifying individual (varying in sample) categorical probabilities. The number of categories generated is equal to \code{ncol(probs)+1}, the categories are labeled as: \code{1,...,ncol(probs)+1}.
}
\examples{
#---------------------------------------------------------------------------------------
# Specifying and simulating from a DAG with one categorical node with constant
# probabilities
#---------------------------------------------------------------------------------------
D <- DAG.empty()
D <- D + node("race",t=0,distr="rcategor",probs=c(0.2,0.1,0.4,0.15,0.05,0.1))
Dset <- set.DAG(D)
simdat <- simobs(Dset, n=200, rndseed=1)

#---------------------------------------------------------------------------------------
# Specifying and simulating from a DAG with a categorical node with varying
# probabilities (probabilities are determined by values sampled for nodes L0 and L1)
#---------------------------------------------------------------------------------------
D <- DAG.empty()
D <- D + node("L0", distr="rnorm", mean=10, sd=5)
D <- D + node("L1", distr="rnorm", mean=10, sd=5)
D <- D + node("L2", distr="rcategor", probs=c(abs(1/L0), abs(1/L1)))
Dset <- set.DAG(D)
simdat <- simobs(Dset, n=200, rndseed=1)
}

