% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SimBetaN2}
\alias{SimBetaN2}
\title{Simulate Transition Matrices
from the Multivariate Normal Distribution
and Project to Stability}
\usage{
SimBetaN2(n, beta, vcov_beta_vec_l, margin = 0.98, tol = 1e-12)
}
\arguments{
\item{n}{Positive integer.
Number of replications.}

\item{beta}{Numeric matrix.
The transition matrix (\eqn{\boldsymbol{\beta}}).}

\item{vcov_beta_vec_l}{Numeric matrix.
Cholesky factorization (\code{t(chol(vcov_beta_vec))})
of the sampling variance-covariance matrix of
\eqn{\mathrm{vec} \left( \boldsymbol{\beta} \right)}.}

\item{margin}{Double in \eqn{(0, 1)}.
Target upper bound for the spectral radius
(default = 0.98).}

\item{tol}{Small positive double added to the denominator
in the scaling factor to avoid division by zero
(default = 1e-12).}
}
\value{
Returns a list of random transition matrices.
}
\description{
This function simulates random transition matrices
from the multivariate normal distribution
then projects each draw to the stability region
using \code{\link[=ProjectToStability]{ProjectToStability()}}.
}
\examples{
n <- 10
beta <- matrix(
  data = c(
    0.7, 0.5, -0.1,
    0.0, 0.6, 0.4,
    0, 0, 0.5
  ),
  nrow = 3
)
vcov_beta_vec_l <- t(chol(0.001 * diag(9)))
SimBetaN2(n = n, beta = beta, vcov_beta_vec_l = vcov_beta_vec_l)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECovEta}()},
\code{\link{LinSDECovY}()},
\code{\link{LinSDEMeanEta}()},
\code{\link{LinSDEMeanY}()},
\code{\link{ProjectToHurwitz}()},
\code{\link{ProjectToStability}()},
\code{\link{SSMCovEta}()},
\code{\link{SSMCovY}()},
\code{\link{SSMMeanEta}()},
\code{\link{SSMMeanY}()},
\code{\link{SimAlphaN}()},
\code{\link{SimBetaN}()},
\code{\link{SimCovDiagN}()},
\code{\link{SimCovN}()},
\code{\link{SimIotaN}()},
\code{\link{SimNuN}()},
\code{\link{SimPhiN}()},
\code{\link{SimPhiN2}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SpectralRadius}()},
\code{\link{TestPhi}()},
\code{\link{TestPhiHurwitz}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{simStateSpace}
\keyword{ssm}
