% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inf_2D_image.R
\name{inf_2D_image}
\alias{inf_2D_image}
\title{Display Inference Results for 2D Predictors}
\usage{
inf_2D_image(
  rejections = NULL,
  B = NULL,
  im.res,
  test.statistic = NULL,
  reject.threshold = NULL,
  binarize.B = TRUE,
  grid.color = "grey",
  n.colors = length(unique(B)),
  B.incl.B0 = TRUE,
  plot.title = TRUE
)
}
\arguments{
\item{rejections}{A binary vector; \code{rejection[i] = 1} means the null hypothesis is
rejected for parameter \code{B[i]}, whereas \code{rejection[i] = 0} means that the null
hypothesis was not rejected for parameter \code{B[i]}.}

\item{B}{A vector of "true" parameter values. For inference purposes, this can be a vector
of actual parameter values, or a binary vector indicating non-zero status.}

\item{im.res}{A vector defining the dimension of spatial data. The first entry is the
number of rows and the second  entry is the number of columns.}

\item{test.statistic}{A vector of test statistics; e.g., t-statistics or p-values that
are used to determine whether or not to reject the null hypothesis.}

\item{reject.threshold}{A list whose first element is the rejection criteria, e.g., the
minimum t-statistic or maximum p-value for which to reject the null hypothesis. The second
element is one of \code{c("greater", "less", "2-tailed")}, which tell the function to reject
when the values in \code{test.statistic} are greater than or less than the threshold,
the test is a 2-tailed, respectively. In the latter case the function internally calculates
the upper or lower threshold needed for the 2-tailed test.}

\item{binarize.B}{Either \code{TRUE} (default) or \code{FALSE}. When
\code{binarize.B = TRUE} the parameter vector is converted to a binary vector
where 1 indicates non-zero parameter and 0 indicates zero-valued parameter.}

\item{grid.color}{Specify the color for the grid lines.}

\item{n.colors}{Determines the number of colors in the printed image. Default is
\code{length(unique(B))}, but it is recommended to use trial and error to determine
the ideal setting for specific situations.}

\item{B.incl.B0}{If \code{B.incl.B0 = TRUE} then the first entry should be the intercept,
B0. \code{B.incl.B0 = FALSE} indicates that the first entry of B is not an intercept.}

\item{plot.title}{When \code{plot.title = TRUE} a title accompanies the output graph, and
\code{plot.title = FALSE} suppresses the title.}
}
\value{
An image depicting the spatial extent of some image characteristic.
}
\description{
Provide graphics for spatial extent of predictor parameters, rejections
and/or the truth/falsity of the rejections.
}
\note{
If both \code{rejections} and \code{B} are specified then the function
provides an image with separate color each for:
\itemize{
    \item No rejection and \code{B[i] = 0} (i.e. True Negative).
    \item No rejection and \code{B[i] != 0} (i.e. False Negative).
    \item Rejection and \code{B[i] = 0} (i.e. False Positive).
    \item Rejection and \code{B[i] != 0} (i.e. True Positive).
}
}
\examples{
## parameter vector
Bex <- beta_builder(row.index = c(rep(5, 3), rep(6, 3), rep(7, 3)),
                    col.index = rep(c(5, 6, 7), 3),
                    im.res = c(10, 10), index.type = "manual",
                    B0 = 0, B.values = 1:9,
                    output.indices = FALSE)

## co-opt beta builder to get rejections
rejex <- beta_builder(row.index = c(rep(4, 3), rep(5, 3), rep(6, 3)),
                      col.index = rep(c(4, 5, 6), 3),
                      im.res = c(10, 10), index.type = "manual",
                      B0 = 0, B.values = rep(1, 9),
                      output.indices = FALSE)[-1]

rejex.sm2 <- beta_builder(row.index = 5:6, col.index = 5:6,
                          im.res = c(10, 10),
                          B0 = 0, B.values = 1,
                          output.indices = FALSE)[-1]

## just B
inf_2D_image(B = Bex, im.res = c(10, 10))
## just rejections
inf_2D_image(rejections = rejex, im.res = c(10, 10))

## both B and rejections
inf_2D_image(rejections = rejex, B = Bex, im.res = c(10, 10))
inf_2D_image(rejections = rejex.sm2, B = Bex, im.res = c(10, 10))

## larger dimension example
Bex2 <- beta_builder(row.index = 5:15, col.index = 16:20,
                     im.res = c(50, 50), B0 = 0,
                     B.values = 1:(length(5:15) * length(16:20)),
                     index.type = "rectangle",
                     output.indices = FALSE)
rejex2 <- beta_builder(row.index = 13:21, col.index = 30:41,
                       im.res = c(50, 50), B0 = 0,
                       B.values = rep(1, (length(13:21) * length(30:41))),
                       index.type = "rectangle",
                       output.indices = FALSE)[-1]
rejex3 <- beta_builder(row.index = 5:20, col.index = 16:30,
                       im.res = c(50, 50), B0 = 0,
                       B.values = rep(1, (length(5:20) * length(16:30))),
                       index.type = "rectangle",
                       output.indices = FALSE)[-1]
rejex4 <- beta_builder(row.index = 5:10, col.index = 16:17,
                       im.res = c(50, 50), B0 = 0,
                       B.values = rep(1, (length(5:10) * length(16:17))),
                       index.type = "rectangle",
                       output.indices = FALSE)[-1]
## images
inf_2D_image(B = Bex2, im.res = c(50, 50))
inf_2D_image(B = Bex2, im.res = c(50, 50), binarize.B = FALSE)
inf_2D_image(rejections = rejex2, im.res = c(50, 50))

## No TP
inf_2D_image(rejections = rejex2, B = Bex2, im.res = c(50, 50))
## ALL TP
inf_2D_image(rejections = Bex2[-1], B = Bex2, im.res = c(50, 50))
## No FN
inf_2D_image(rejections = rejex3, B = Bex2, im.res = c(50, 50))
## No FP, but FN
inf_2D_image(rejections = rejex4, im.res = c(50, 50))
inf_2D_image(B = Bex2, im.res = c(50, 50))
inf_2D_image(rejections = rejex4, B = Bex2, im.res = c(50, 50))
}
