% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig_extract.R
\name{sig_extract}
\alias{sig_extract}
\title{Extract Signatures through NMF}
\usage{
sig_extract(
  nmf_matrix,
  n_sig,
  nrun = 10,
  cores = 1,
  method = "brunet",
  optimize = FALSE,
  pynmf = FALSE,
  use_conda = TRUE,
  py_path = "/Users/wsx/anaconda3/bin/python",
  seed = 123456,
  ...
)
}
\arguments{
\item{nmf_matrix}{a \code{matrix} used for NMF decomposition with rows indicate samples and columns indicate components.}

\item{n_sig}{number of signature. Please run \link{sig_estimate} to select a suitable value.}

\item{nrun}{a \code{numeric} giving the number of run to perform for each value in \code{range}, \code{nrun} set to 30~50 is
enough to achieve robust result.}

\item{cores}{number of cpu cores to run NMF.}

\item{method}{specification of the NMF algorithm. Use 'brunet' as default.
Available methods for NMF decompositions are 'brunet', 'lee', 'ls-nmf', 'nsNMF', 'offset'.}

\item{optimize}{if \code{TRUE}, then refit the denovo signatures with QP method, see \link{sig_fit}.}

\item{pynmf}{if \code{TRUE}, use Python NMF driver \href{http://nimfa.biolab.si/index.html}{Nimfa}.
The seed currently is not used by this implementation.}

\item{use_conda}{if \code{TRUE}, create an independent conda environment to run NMF.}

\item{py_path}{path to Python executable file, e.g. '/Users/wsx/anaconda3/bin/python'. In my
test, it is more stable than \code{use_conda=TRUE}. You can install the Nimfa package by yourself
or set \code{use_conda} to \code{TRUE} to install required Python environment, and then set this option.}

\item{seed}{specification of the starting point or seeding method, which will compute a starting point,
usually using data from the target matrix in order to provide a good guess.}

\item{...}{other arguments passed to \code{\link[NMF:nmf]{NMF::nmf()}}.}
}
\value{
a \code{list} with \code{Signature} class.
}
\description{
Do NMF de-composition and then extract signatures.
}
\examples{
\donttest{
load(system.file("extdata", "toy_copynumber_tally_M.RData",
  package = "sigminer", mustWork = TRUE
))
# Extract copy number signatures
res <- sig_extract(cn_tally_M$nmf_matrix, 2, nrun = 1)
}
}
\references{
Gaujoux, Renaud, and Cathal Seoighe. "A flexible R package for nonnegative matrix factorization." BMC bioinformatics 11.1 (2010): 367.

Mayakonda, Anand, et al. "Maftools: efficient and comprehensive analysis of somatic variants in cancer." Genome research 28.11 (2018): 1747-1756.
}
\seealso{
\link{sig_tally} for getting variation matrix,
\link{sig_estimate} for estimating signature number for \link{sig_extract}, \link{sig_auto_extract} for
extracting signatures using automatic relevance determination technique.
}
\author{
Shixiang Wang
}
