% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_copynumber.R
\name{read_copynumber}
\alias{read_copynumber}
\title{Read Absolute Copy Number Profile}
\usage{
read_copynumber(
  input,
  pattern = NULL,
  ignore_case = FALSE,
  seg_cols = c("Chromosome", "Start.bp", "End.bp", "modal_cn"),
  samp_col = "sample",
  join_adj_seg = TRUE,
  use_all = FALSE,
  min_segnum = 0L,
  max_copynumber = 20L,
  genome_build = c("hg19", "hg38"),
  genome_measure = c("called", "wg"),
  complement = TRUE,
  ...
)
}
\arguments{
\item{input}{a \code{data.frame} or a file or a directory contains copy number profile.}

\item{pattern}{an optional regular expression used to select part of files if
\code{input} is a directory, more detail please see \link{list.files} function.}

\item{ignore_case}{logical. Should pattern-matching be case-insensitive?}

\item{seg_cols}{four characters used to specify chromosome, start position,
end position and copy number value in \code{input}, respectively.
Default use names from ABSOLUTE calling result.}

\item{samp_col}{a character used to specify the sample column name. If \code{input}
is a directory and cannot find \code{samp_col}, sample names will use file names
(set this parameter to \code{NULL} is recommended in this case).}

\item{join_adj_seg}{if \code{TRUE} (default), join adjacent segments with
same copy number value. This is helpful for precisely count the number of breakpoint.
When set \code{use_all=TRUE}, the mean function will be applied to extra numeric columns
and unique string columns will be pasted by comma for joined records.}

\item{use_all}{default is \code{FALSE}. If \code{True}, use all columns from raw input.}

\item{min_segnum}{minimal number of copy number segments within a sample.}

\item{max_copynumber}{bigger copy number within a sample will be reset to this value.}

\item{genome_build}{genome build version, should be 'hg19' or 'hg38'.}

\item{genome_measure}{default is 'called', can be 'wg' or 'called'.
Set 'called' will use called segments size to compute total size for CNA burden calculation,
this option is useful for WES and target sequencing.
Set 'wg' will use autosome size from genome build, this option is useful for WGS, SNP etc..}

\item{complement}{if \code{TRUE}, complement chromosome (except 'Y') does not show in input data
with normal copy 2 and force \code{use_all} to \code{FALSE} (no matter what user input).}

\item{...}{other parameters pass to \code{\link[data.table:fread]{data.table::fread()}}}
}
\value{
a \link{CopyNumber} object.
}
\description{
Read \strong{absolute} copy number profile for preparing CNV signature
analysis.
}
\examples{
# Load toy dataset of absolute copynumber profile
load(system.file("extdata", "toy_segTab.RData",
  package = "sigminer", mustWork = TRUE
))
cn <- read_copynumber(segTabs,
  seg_cols = c("chromosome", "start", "end", "segVal"),
  genome_build = "hg19", complement = FALSE
)
cn
cn_subset <- subset(cn, sample == "TCGA-DF-A2KN-01A-11D-A17U-01")

tab_file <- system.file("extdata", "metastatic_tumor.segtab.txt",
  package = "sigminer", mustWork = TRUE
)
cn2 <- read_copynumber(tab_file)
cn2
}
\seealso{
\link{read_maf} for reading mutation data to \link{MAF} object.
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
