% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{sg_make_nodes}
\alias{sg_make_nodes}
\alias{sg_make_edges}
\alias{sg_make_nodes_edges}
\title{Generate data}
\usage{
sg_make_nodes(n = 10, colors = c("#B1E2A3", "#98D3A5", "#328983",
  "#1C5C70", "#24C96B"))

sg_make_edges(nodes, n = nrow(nodes) * 1.5)

sg_make_nodes_edges(n, ...)
}
\arguments{
\item{n}{Number of nodes.}

\item{colors}{Color palette to use.}

\item{nodes}{Nodes, as generated by \code{sg_make_nodes}.}

\item{...}{Any other argument to pass to \link[igraph]{sample_pa}.}
}
\value{
\code{tibble} of nodes or edges or a \code{list} of the latter.
}
\description{
Generate nodes and edges.
}
\section{Functions}{

\itemize{
  \item{\code{sg_make_nodes} generate data.frame nodes.}
  \item{\code{sg_make_edges} generate data.frame edges.}
  \item{\code{sg_make_nodes_edges} generate list of nodes and edges.}
}
}

\examples{
nodes <- sg_make_nodes()
edges <- sg_make_edges(nodes)

sigmajs() \%>\%
sg_nodes(nodes, id, label, size, color) \%>\%
sg_edges(edges, id, source, target) \%>\%
sg_settings(defaultNodeColor = "#0011ff")

}
