% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find-optimal-distance.R
\name{find_optimal_distance}
\alias{find_optimal_distance}
\title{Function that finds the distance at which the sprint, probe, or
    FV profile is optimal (i.e., equal to 100 perc)}
\usage{
find_optimal_distance(..., optimal_func = optimal_FV, min = 1, max = 60)
}
\arguments{
\item{...}{Forwarded to selected \code{optimal_func}}

\item{optimal_func}{Selected profile optimization function. Default is \code{\link{optimal_FV}}}

\item{min, max}{Distance over which to find optimal profile distance}
}
\value{
Distance
}
\description{
Function that finds the distance at which the sprint, probe, or
    FV profile is optimal (i.e., equal to 100 perc)
}
\examples{
MSS <- 10
MAC <- 8
bodymass <- 75

fv <- make_FV_profile(MSS, MAC, bodymass)

find_optimal_distance(
  F0 = fv$F0_poly,
  V0 = fv$V0_poly,
  bodymass = fv$bodymass,
  optimal_func = optimal_FV,
  method = "max")

find_optimal_distance(
  MSS = MSS,
  MAC = MAC,
  optimal_func = optimal_MSS_MAC
)

find_optimal_distance(
  MSS = MSS,
  MAC = MAC,
  optimal_func = probe_MSS_MAC
)
}
