% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{MRPModel-method-fit}
\alias{MRPModel-method-fit}
\alias{fit}
\title{Fit multilevel regression model using cmdstanr}
\usage{
fit(n_iter = 2000, n_chains = 4, seed = NULL, ...)
}
\arguments{
\item{n_iter}{Number of MCMC iterations per chain (including warmup iterations). Default is 2000.}

\item{n_chains}{Number of MCMC chains to run. Default is 4.}

\item{seed}{Random seed for reproducibility. Default is \code{NULL}.}

\item{...}{Additional arguments passed to CmdStanR \verb{$sample()} method.}
}
\value{
No return value, called for side effects.
}
\description{
The \verb{$fit()} method of an \code{MRPModel} object fits the model using
Stan's main Markov chain Monte Carlo (MCMC) algorithm. Check out the
\href{https://mrp-interface.github.io/shinymrp/articles/example#fit}{More examples of R6 classes}
vignette for usage examples.
}
