% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fab_button.R
\name{fab_button}
\alias{fab_button}
\title{Create a FAB button}
\usage{
fab_button(..., inputId = NULL, icon = NULL, status = "default")
}
\arguments{
\item{...}{HTML tags 'a' or 'button' or \code{actionButton} (with \code{NULL} labels).}

\item{inputId}{Id for the FAB button (act like an \code{actionButton}).}

\item{icon}{An \code{icon} for the main button.}

\item{status}{Bootstra^p status to apply to the main button.}
}
\description{
Create a fixed button in bottom right corner with additional button(s) in it
}
\examples{
if (interactive()) {
  library(shiny)
  library(shinymanager)

  ui <- fluidPage(

    tags$h1("FAB button"),

    tags$p("FAB button:"),
    verbatimTextOutput(outputId = "res_fab"),

    tags$p("Logout button:"),
    verbatimTextOutput(outputId = "res_logout"),

    tags$p("Info button:"),
    verbatimTextOutput(outputId = "res_info"),

    fab_button(
      actionButton(
        inputId = "logout",
        label = NULL,
        tooltip = "Logout",
        icon = icon("sign-out")
      ),
      actionButton(
        inputId = "info",
        label = NULL,
        tooltip = "Information",
        icon = icon("info")
      ),
      inputId = "fab"
    )

  )

  server <- function(input, output, session) {

    output$res_fab <- renderPrint({
      input$fab
    })

    output$res_logout <- renderPrint({
      input$logout
    })

    output$res_info <- renderPrint({
      input$info
    })

  }

  shinyApp(ui, server)
}
}
