% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hidden.R
\name{hidden}
\alias{hidden}
\title{Initialize a Shiny tag as hidden}
\usage{
hidden(...)
}
\arguments{
\item{...}{Shiny tag (or tagList or list of of tags) to make invisible}
}
\value{
The tag (or tags) that was given as an argument in a hidden state.
}
\description{
Create a Shiny tag that is invisible when the Shiny app starts. The tag can
be made visible later with \code{shinyjs::toggle} or \code{shinyjs::show}.
}
\note{
\code{shinyjs} must be initialized with a call to \code{useShinyjs()}
in the app's ui.
}
\examples{
if (interactive()) {
  shiny::shinyApp(
    ui = shiny::fluidPage(
      useShinyjs(),  # Set up shinyjs
      shiny::actionButton("btn", "Click me"),
      hidden(
        shiny::p(id = "element", "I was born invisible")
      )
    ),
    server = function(input, output) {
      shiny::observeEvent(input$btn, {
        show("element")
      })
    }
  )
}

hidden(shiny::span(id = "a"), shiny::div(id = "b"))
hidden(shiny::tagList(shiny::span(id = "a"), shiny::div(id = "b")))
hidden(list(shiny::span(id = "a"), shiny::div(id = "b")))
}
\seealso{
\code{\link[shinyjs]{useShinyjs}},
\code{\link[shinyjs]{toggle}},
\code{\link[shinyjs]{show}},
\code{\link[shinyjs]{hide}}
}

