% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notify.R
\name{notify}
\alias{notify}
\alias{notify_success}
\alias{notify_failure}
\alias{notify_info}
\alias{notify_warning}
\title{Notifications}
\usage{
notify(
  text,
  ...,
  timeout = 3000,
  position = c("right-top", "right-bottom", "left-top", "left-bottom", "center-top",
    "center-bottom", "center-center"),
  type = c("success", "failure", "info", "warning"),
  session = shiny::getDefaultReactiveDomain()
)

notify_success(text, ..., timeout = 3000, position = "right-top")

notify_failure(text, ..., timeout = 3000, position = "right-top")

notify_info(text, ..., timeout = 3000, position = "right-top")

notify_warning(text, ..., timeout = 3000, position = "right-top")
}
\arguments{
\item{text}{Text to be displayed.}

\item{...}{Options passed to JavaScript method, see \code{\link[=config_notify]{config_notify()}}.}

\item{timeout}{The delay in milliseconds to hide and remove the notifications.}

\item{position}{Position where to display the notification.}

\item{type}{Type of notification: \code{success}, \code{failure}, \code{info} or \code{warning}.}

\item{session}{Default Shiny session.}
}
\value{
No value.
}
\description{
Send notifications to the user.
}
\examples{
library(shiny)
library(shinybusy)

ui <- fluidPage(
  tags$h2("notify examples"),
  tags$p(
    "More examples available on the official website:",
    tags$a("https://notiflix.github.io/notify")
  ),
  actionButton("success", "Success"),
  actionButton("failure", "Failure"),
  actionButton("info", "Info"),
  actionButton("warning", "Warning")
)

server <- function(input, output, session) {

  observeEvent(input$success, {
    notify_success("Well done!")
  })

  observeEvent(input$failure, {
    notify_failure("Oups...")
  })

  observeEvent(input$info, {
    notify_info("For your information")
  })

  observeEvent(input$warning, {
    notify_warning("Be careful!")
  })

}

if (interactive())
  shinyApp(ui, server)
}
\references{
Notify module from \href{https://github.com/notiflix/Notiflix}{Notiflix} library.
More documentation and examples are available on the official website:
\url{https://notiflix.github.io/notify}.
}
