% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sweetalert.R
\name{progressSweetAlert}
\alias{progressSweetAlert}
\title{Progress bar in a sweet alert}
\usage{
progressSweetAlert(
  session = getDefaultReactiveDomain(),
  id,
  value,
  total = NULL,
  display_pct = FALSE,
  size = NULL,
  status = NULL,
  striped = FALSE,
  title = NULL,
  ...
)
}
\arguments{
\item{session}{The \code{session} object passed to function given to shinyServer.}

\item{id}{An id used to update the progress bar.}

\item{value}{Value of the progress bar between 0 and 100, if >100 you must provide total.}

\item{total}{Used to calculate percentage if value > 100, force an indicator to appear on top right of the progress bar.}

\item{display_pct}{logical, display percentage on the progress bar.}

\item{size}{Size, \code{NULL} by default or a value in 'xxs', 'xs', 'sm', only work with package \code{shinydashboard}.}

\item{status}{Color, must be a valid Bootstrap status : primary, info, success, warning, danger.}

\item{striped}{logical, add a striped effect.}

\item{title}{character, optional title.}

\item{...}{Arguments passed to \code{\link[=sendSweetAlert]{sendSweetAlert()}}}
}
\description{
Progress bar in a sweet alert
}
\examples{
if (interactive()) {

library("shiny")
library("shinyWidgets")


ui <- fluidPage(
  tags$h1("Progress bar in Sweet Alert"),
  useSweetAlert(), # /!\ needed with 'progressSweetAlert'
  actionButton(
    inputId = "go",
    label = "Launch long calculation !"
  )
)

server <- function(input, output, session) {

  observeEvent(input$go, {
    progressSweetAlert(
      session = session, id = "myprogress",
      title = "Work in progress",
      display_pct = TRUE, value = 0
    )
    for (i in seq_len(50)) {
      Sys.sleep(0.1)
      updateProgressBar(
        session = session,
        id = "myprogress",
        value = i*2
      )
    }
    closeSweetAlert(session = session)
    sendSweetAlert(
      session = session,
      title =" Calculation completed !",
      type = "success"
    )
  })

}

shinyApp(ui = ui, server = server)

}
}
\seealso{
\code{\link[=progressBar]{progressBar()}}
}
