% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setShadow.R
\name{setShadow}
\alias{setShadow}
\title{Custom shadows}
\usage{
setShadow(id = NULL, class = NULL)
}
\arguments{
\item{id}{Use this argument if you want to target an individual element.}

\item{class}{The element to which the shadow should be applied.
For example, class is set to box.}
}
\description{
Allow to apply a shadow on a given element.
}
\examples{
 if (interactive()) {

  library(shiny)
  library(shinydashboard)
  library(shinydashboardPlus)
  library(shinyWidgets)

  boxTag <- box(
   title = "Closable box, with label",
   closable = TRUE,
   label = boxLabel(
    text = 1,
    status = "danger"
   ),
   status = "warning",
   solidHeader = FALSE,
   collapsible = TRUE,
   p("Box Content")
  )

  shinyApp(
   ui = dashboardPage(
     header = dashboardHeader(),
     sidebar = dashboardSidebar(),
     body = dashboardBody(

      setShadow(class = "box"),
      setShadow(id = "my-progress"),

      tags$h2("Add shadow to the box class"),
      fluidRow(boxTag, boxTag),
      tags$h2("Add shadow only to the first element using id"),
      tagAppendAttributes(
       shinydashboardPlus::progressBar(
        value = 10,
        striped = TRUE,
        animated = TRUE
       ),
       id = "my-progress"
      ),
      shinydashboardPlus::progressBar(
        value = 50,
        status = "warning"
      ),
      shinydashboardPlus::progressBar(
        value = 20,
        status = "danger"
      )
     ),
     controlbar = dashboardControlbar(),
     title = "DashboardPage"
   ),
   server = function(input, output) { }
  )
}
}
