% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/range_stat_aggregator.R
\docType{class}
\name{range_stat_aggregator}
\alias{range_stat_aggregator}
\title{Aggregation which returns the ranges and nominal values
within small data ranges}
\format{
An \code{R6::R6Class} object
}
\description{
This aggregator divides the data into no-overlapping intervals
and calculate specific statistics that represents the range and nominal
values of the data, such as the max, min and mean.
}
\examples{
data(noise_fluct)
agg <- range_stat_aggregator$new(
  ylwr = min, y = mean, yupr = max, interleave_gaps = TRUE
)
d_agg <- agg$aggregate(noise_fluct$time, noise_fluct$f500, 100)
plotly::plot_ly(x = d_agg$x, y = d_agg$y, type = "scatter", mode = "lines") \%>\%
  plotly::add_trace(x = d_agg$x, y = d_agg$ylwr, type = "scatter", mode = "lines")\%>\%
  plotly::add_trace(x = d_agg$x, y = d_agg$yupr, type = "scatter", mode = "lines")

}
\section{Super classes}{
\code{shinyHugePlot::aggregator} -> \code{shinyHugePlot::rng_aggregator} -> \code{range_stat_aggregator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-range_stat_aggregator-new}{\code{range_stat_aggregator$new()}}
\item \href{#method-range_stat_aggregator-clone}{\code{range_stat_aggregator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="aggregate"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-aggregate'><code>shinyHugePlot::aggregator$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="set_parameters"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-set_parameters'><code>shinyHugePlot::aggregator$set_parameters()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="rng_aggregator" data-id="as_plotly_range"><a href='../../shinyHugePlot/html/rng_aggregator.html#method-rng_aggregator-as_plotly_range'><code>shinyHugePlot::rng_aggregator$as_plotly_range()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="rng_aggregator" data-id="as_range"><a href='../../shinyHugePlot/html/rng_aggregator.html#method-rng_aggregator-as_range'><code>shinyHugePlot::rng_aggregator$as_range()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-range_stat_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-range_stat_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the aggregator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{range_stat_aggregator$new(
  ...,
  ylwr = min,
  y = mean,
  yupr = max,
  interleave_gaps,
  coef_gap,
  NA_position,
  accepted_datatype
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{yupr, y, ylwr}}{Functions.
Statistical values are calculated using this function.
By default, \code{max, mean, min}, respectively.
Note that the NA values are omitted automatically.}

\item{\code{interleave_gaps, coef_gap, NA_position, accepted_datatype, ...}}{Arguments pass to the constructor of \code{aggregator} object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-range_stat_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-range_stat_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{range_stat_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
