% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_func_aggregator.R
\docType{class}
\name{custom_func_aggregator}
\alias{custom_func_aggregator}
\title{Aggregation using a user-defined function.}
\format{
An \code{R6::R6Class} object
}
\description{
Arbitrary function can be applied using this aggregation class.
}
\examples{
custom_agg_func <- function(x, y, n_out) {
  bin_width <- floor(length(x)/n_out)
  x_idx <- seq(floor(bin_width / 2), bin_width * n_out, bin_width)
  y_mat <- y[1:(bin_width * n_out)] \%>\%
    matrix(nrow = bin_width)
  y_agg <- apply(y_mat, 2, quantile, probs = 0.25)
  return(list(x = x[x_idx], y = y_agg))
}
data(noise_fluct)
agg <- custom_func_aggregator$new(
  aggregation_func = custom_agg_func, interleave_gaps = TRUE
  )
d_agg <- agg$aggregate(
  x = noise_fluct$time, y = noise_fluct$f500, n_out = 1000
  )
plotly::plot_ly(x = d_agg$x, y = d_agg$y, type = "scatter", mode = "lines")
}
\section{Super class}{
\code{shinyHugePlot::aggregator} -> \code{custom_func_aggregator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-custom_func_aggregator-new}{\code{custom_func_aggregator$new()}}
\item \href{#method-custom_func_aggregator-set_aggregation_func}{\code{custom_func_aggregator$set_aggregation_func()}}
\item \href{#method-custom_func_aggregator-clone}{\code{custom_func_aggregator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="aggregate"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-aggregate'><code>shinyHugePlot::aggregator$aggregate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="shinyHugePlot" data-topic="aggregator" data-id="set_parameters"><a href='../../shinyHugePlot/html/aggregator.html#method-aggregator-set_parameters'><code>shinyHugePlot::aggregator$set_parameters()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-custom_func_aggregator-new"></a>}}
\if{latex}{\out{\hypertarget{method-custom_func_aggregator-new}{}}}
\subsection{Method \code{new()}}{
Constructor of the Aggregator.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{custom_func_aggregator$new(
  ...,
  aggregation_func,
  interleave_gaps,
  coef_gap,
  NA_position,
  accepted_datatype
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{aggregation_func}}{Function.
User-defined function to aggregate data,
of which arguments are \code{x}, \code{y} and \code{n_out}.}

\item{\code{interleave_gaps, coef_gap, NA_position, accepted_datatype, ...}}{Arguments pass to the constructor of \code{aggregator} object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-custom_func_aggregator-set_aggregation_func"></a>}}
\if{latex}{\out{\hypertarget{method-custom_func_aggregator-set_aggregation_func}{}}}
\subsection{Method \code{set_aggregation_func()}}{
Set a function to aggregate the data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{custom_func_aggregator$set_aggregation_func(aggregation_func)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{aggregation_func}}{Function.
User-defined function to aggregate data,
of which arguments are \code{x}, \code{y} and \code{n_out}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-custom_func_aggregator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-custom_func_aggregator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{custom_func_aggregator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
