\name{showReactLog}
\alias{showReactLog}
\title{Reactive Log Visualizer}
\usage{
  showReactLog()
}
\description{
  Provides an interactive browser-based tool for
  visualizing reactive dependencies and execution in your
  application.
}
\details{
  To use the reactive log visualizer, start with a fresh R
  session and run the command
  \code{options(shiny.reactlog=TRUE)}; then launch your
  application in the usual way (e.g. using
  \code{\link{runApp}}). At any time you can hit Ctrl+F3
  (or for Mac users, Command+F3) in your web browser to
  launch the reactive log visualization.

  The reactive log visualization only includes reactive
  activity up until the time the report was loaded. If you
  want to see more recent activity, refresh the browser.

  Note that Shiny does not distinguish between reactive
  dependencies that "belong" to one Shiny user session
  versus another, so the visualization will include all
  reactive activity that has taken place in the process,
  not just for a particular application or session.

  As an alternative to pressing Ctrl/Command+F3--for
  example, if you are using reactives outside of the
  context of a Shiny application--you can run the
  \code{showReactLog} function, which will generate the
  reactive log visualization as a static HTML file and
  launch it in your default browser. In this case,
  refreshing your browser will not load new activity into
  the report; you will need to call \code{showReactLog()}
  explicitly.

  For security and performance reasons, do not enable
  \code{shiny.reactlog} in production environments. When
  the option is enabled, it's possible for any user of your
  app to see at least some of the source code of your
  reactive expressions and observers.
}

