% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layouts.R
\name{sidebar_panel}
\alias{sidebar_panel}
\alias{main_panel}
\alias{sidebar_layout}
\alias{sidebarPanel}
\alias{mainPanel}
\alias{sidebarLayout}
\title{Creates div containing children elements of sidebar panel}
\usage{
sidebar_panel(..., width = 1)

main_panel(..., width = 3)

sidebar_layout(
  sidebar_panel,
  main_panel,
  mirrored = FALSE,
  min_height = "auto",
  container_style = "",
  area_styles = list(sidebar_panel = "", main_panel = "")
)

sidebarPanel(..., width = 6)

mainPanel(..., width = 10)

sidebarLayout(
  sidebarPanel,
  mainPanel,
  position = c("left", "right"),
  fluid = TRUE
)
}
\arguments{
\item{...}{Container's children elements}

\item{width}{Width of main panel container as relative value}

\item{sidebar_panel}{Sidebar panel component}

\item{main_panel}{Main panel component}

\item{mirrored}{If TRUE sidebar is located on the right side,
if FALSE - on the left side (default)}

\item{min_height}{Sidebar layout container keeps the minimum height, if
specified. It should be formatted as a string with css units}

\item{container_style}{CSS declarations for grid container}

\item{area_styles}{List of CSS declarations for each grid area inside}

\item{sidebarPanel}{same as \code{sidebar_panel}}

\item{mainPanel}{same as \code{main_panel}}

\item{position}{vector with position of sidebar elements in order sidebar, main}

\item{fluid}{TRUE to use fluid layout; FALSE to use fixed layout.}
}
\value{
Container with sidebar and main panels
}
\description{
Creates div containing children elements of sidebar panel

Creates div containing children elements of main panel

Creates grid layout composed of sidebar and main panels
}
\examples{
if (interactive()){
  library(shiny)
  library(shiny.semantic)
  ui <- semanticPage(
    titlePanel("Hello Shiny!"),
    sidebar_layout(
      sidebar_panel(
        shiny.semantic::sliderInput("obs",
                                    "Number of observations:",
                                    min = 0,
                                    max = 1000,
                                    value = 500),
                                    width = 3
      ),
      main_panel(
        plotOutput("distPlot"),
        width = 4
      ),
      mirrored = TRUE
    )
  )
  server <- function(input, output) {
    output$distPlot <- renderPlot({
      hist(rnorm(input$obs))
    })
  }
}
}
