% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsl.R
\name{dropdown}
\alias{dropdown}
\title{Create dropdown Semantic UI component}
\usage{
dropdown(name, choices, choices_value = choices, default_text = "Select",
  value = NULL)
}
\arguments{
\item{name}{Input name. Reactive value is available under input[[name]].}

\item{choices}{All available options one can select from.}

\item{choices_value}{What reactive value should be used for corresponding
choice.}

\item{default_text}{Text to be visible on dropdown when nothing is selected.}

\item{value}{Pass value if you want to initialize selection for dropdown.}
}
\description{
This creates a default dropdown using Semantic UI styles with Shiny input.
Dropdown is already initialized and available under input[[name]].
}
\examples{
## Only run examples in interactive R sessions
if (interactive()) {

  library(shiny)
  library(shiny.semantic)
  ui <- function() {
      shinyUI(
        semanticPage(
          title = "Dropdown example",
          suppressDependencies("bootstrap"),
          uiOutput("dropdown"),
          p("Selected letter:"),
          textOutput("selected_letter")
       )
     )
  }
  server <- shinyServer(function(input, output) {
     output$dropdown <- renderUI({
         dropdown("simple_dropdown", LETTERS, value = "A")
     })
     output$selected_letter <- renderText(input[["simple_dropdown"]])
  })

  shinyApp(ui = ui(), server = server)
}

}
