% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/router.R
\name{change_page}
\alias{change_page}
\title{Change the currently displayed page.}
\usage{
change_page(page, session = shiny::getDefaultReactiveDomain(), mode = "push")
}
\arguments{
\item{page}{The new URL to go to. Should just be the path component of the
URL, with optional query, e.g. "/learner?id=\%d"}

\item{session}{The current Shiny session.}

\item{mode}{("replace" or "push") whether to replace current history or push a new one.
More in \code{shiny::updateQueryString}.}
}
\description{
Works by sending a message up to
our reactive input binding on the client side, which tells page.js to update
the window URL accordingly, then tells client side shiny that our reactive
input binding has changed, then that comes back down to our router callback
function and all other observers watching \code{get_page()} or similar.
}
