% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCP_plot.R
\name{PCP_plot}
\alias{PCP_plot}
\title{Percentiles of Cumulative Precipitation}
\usage{
PCP_plot(
  x,
  this.year,
  this.day = NULL,
  method = "exemplar",
  q.color = "RoyalBlue",
  c.color = "firebrick",
  ...
)
}
\arguments{
\item{x}{result from \code{CDECquery} for now, will need to generalize to other sources}

\item{this.year}{a single water year, e.g. 2020}

\item{this.day}{optional integer representing days since start of selected water year}

\item{method}{'exemplar' or 'daily', currently 'exemplar' is the only method available}

\item{q.color}{color of percentiles cumulative precipitation}

\item{c.color}{color of selected year}

\item{...}{additional arguments to \code{plot}}
}
\value{
nothing, this function is called to create graphical output
}
\description{
Generate a plot representing percentiles of cumulative precipitation, given a historic record, and criteria for selecting a year of data for comparison.
}
\details{
This is very much a work in progress. Further examples at \url{https://ncss-tech.github.io/AQP/sharpshootR/CDEC.html}, and \url{https://ncss-tech.github.io/AQP/sharpshootR/cumulative-PPT.html}.
}
\seealso{
\code{\link[soilDB:waterDayYear]{soilDB::waterDayYear()}}
}
\author{
D.E. Beaudette
}
\keyword{hplots}
