% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_plot.R
\name{plot.clustering}
\alias{plot.clustering}
\title{Consensus matrix heatmap}
\usage{
\method{plot}{clustering}(
  x,
  linkage = "complete",
  argmax_id = NULL,
  theta = NULL,
  theta_star = NULL,
  col = c("ivory", "navajowhite", "tomato", "darkred"),
  lines = TRUE,
  col.lines = c("blue"),
  lwd.lines = 2,
  tick = TRUE,
  axes = TRUE,
  col.axis = NULL,
  cex.axis = 1,
  xlas = 2,
  ylas = 2,
  bty = "n",
  ...
)
}
\arguments{
\item{x}{output of \code{\link{Clustering}}.}

\item{linkage}{character string indicating the type of linkage used in
hierarchical clustering to define the stable clusters. Possible values
include \code{"complete"}, \code{"single"} and \code{"average"} (see
argument \code{"method"} in \code{\link[stats]{hclust}} for a full list).}

\item{argmax_id}{optional indices of hyper-parameters. If
\code{argmax_id=NULL}, the calibrated hyper-parameters are used.}

\item{theta}{optional vector of cluster membership. If provided, the ordering
of the items should be the same as in \code{\link{Clusters}}. This argument
is used to re-order the consensus matrix.}

\item{theta_star}{optional vector of true cluster membership. If provided,
the ordering of the items should be the same as in \code{\link{Clusters}}.
This argument is used to define item colours.}

\item{col}{vector of colours.}

\item{lines}{logical indicating if lines separating the clusters provided in
\code{theta} should be displayed.}

\item{col.lines}{colour of the lines separating the clusters.}

\item{lwd.lines}{width of the lines separating the clusters.}

\item{tick}{logical indicating if axis tickmarks should be displayed.}

\item{axes}{logical indicating if item labels should be displayed.}

\item{col.axis}{optional vector of cluster colours.}

\item{cex.axis}{font size for axes.}

\item{xlas}{orientation of labels on the x-axis, as \code{las} in
\code{\link[graphics]{par}}.}

\item{ylas}{orientation of labels on the y-axis, as \code{las} in
\code{\link[graphics]{par}}.}

\item{bty}{character string indicating if the box around the plot should be
drawn. Possible values include: \code{"o"} (default, the box is drawn), or
\code{"n"} (no box).}

\item{...}{additional arguments passed to \code{\link[fake]{Heatmap}}.}
}
\value{
A heatmap.
}
\description{
Creates a heatmap of the (calibrated) consensus matrix. See examples in
\code{\link{Clustering}}.
}
