% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sharp-package.R
\docType{package}
\name{sharp-package}
\alias{sharp-package}
\title{sharp: Stability-enHanced Approaches using Resampling Procedures}
\description{
In stability selection and consensus clustering, resampling techniques are
used to enhance the reliability of the results. In this package,
hyper-parameters are calibrated by maximising model stability, which is
measured by the negative log-likelihood under the null hypothesis that all
selection (or co-membership) probabilities are identical. Functions are
readily implemented for the use of LASSO regression, sparse PCA, sparse
(group) PLS or graphical LASSO in stability selection, and hierarchical
clustering, partitioning around medoids, K means or Gaussian mixture models
in consensus clustering.
}
\details{
\tabular{ll}{ Package: \tab sharp\cr Type: \tab Package\cr Version: \tab
1.3.0 \cr Date: \tab 2023-01-17 \cr License: \tab GPL (>= 3)\cr Maintainer:
\tab Barbara Bodinier \email{b.bodinier@imperial.ac.uk}}
}
\examples{
\donttest{
oldpar <- par(no.readonly = TRUE)
par(mar = c(5, 5, 5, 5))

## Regression models
# Data simulation
set.seed(1)
simul <- SimulateRegression(n = 100, pk = 50)

# Stability selection
stab <- VariableSelection(xdata = simul$xdata, ydata = simul$ydata)
CalibrationPlot(stab)
summary(stab)
SelectedVariables(stab)


## Graphical models
# Data simulation
set.seed(1)
simul <- SimulateGraphical(n = 100, pk = 20, topology = "scale-free")

# Stability selection
stab <- GraphicalModel(xdata = simul$data)
CalibrationPlot(stab)
summary(stab)
plot(stab)


## PCA models
# Data simulation
set.seed(1)
simul <- SimulateComponents(pk = c(5, 3, 4))
plot(simul)

# Stability selection
stab <- BiSelection(
  xdata = simul$data,
  ncomp = 3,
  implementation = SparsePCA
)
CalibrationPlot(stab)
summary(stab)
SelectedVariables(stab)


## PLS models
# Data simulation
set.seed(1)
simul <- SimulateRegression(n = 50, pk = c(10, 20, 30), family = "gaussian")

# Stability selection
stab <- BiSelection(
  xdata = simul$xdata, ydata = simul$ydata,
  family = "gaussian", ncomp = 3,
  implementation = SparsePLS
)
CalibrationPlot(stab)
summary(stab)
plot(stab)

par(oldpar)
}
}
\references{
\insertRef{ourstabilityselection}{sharp}

  \insertRef{stabilityselectionMB}{sharp}

  \insertRef{ConsensusClustering}{sharp}
}
