% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sv_importance.R
\name{sv_importance}
\alias{sv_importance}
\alias{sv_importance.default}
\alias{sv_importance.shapviz}
\title{SHAP Importance Plots}
\usage{
sv_importance(object, ...)

\method{sv_importance}{default}(object, ...)

\method{sv_importance}{shapviz}(
  object,
  kind = c("bar", "beeswarm", "both", "no"),
  max_display = 15L,
  show_other = TRUE,
  fill = "#fca50a",
  bar_width = 2/3,
  bee_width = 0.4,
  bee_adjust = 0.5,
  viridis_args = getOption("shapviz.viridis_args"),
  color_bar_title = "Feature value",
  show_numbers = FALSE,
  format_fun = format_max,
  number_size = 3.2,
  ...
)
}
\arguments{
\item{object}{An object of class "shapviz".}

\item{...}{Arguments passed to \code{geom_bar()} (if \code{kind = "bar"}) or
to \code{geom_point()} otherwise.
For instance, passing \code{alpha = 0.2} will produce semi-transparent beeswarms,
and setting \code{size = 3} will produce larger dots.}

\item{kind}{Should a "bar" plot (the default), a "beeswarm" plot, or "both" be shown?
Set to "no" in order to suppress plotting. In that case, the sorted
SHAP feature importances of all variables are returned.}

\item{max_display}{Maximum number of features (with highest importance) to plot.
If there are more, the least important variables are collapsed to an "other" group:
their SHAP values are added and their min-max-scaled feature values are added as
well (and the resulting vector is min-max-scaled again).
Set to \code{Inf} to show all features.
Has no effect if \code{kind = "no"} or if \code{show_other = FALSE}.}

\item{show_other}{If the number of features is larger than \code{max_display}:
Should the "other" group be shown (default) or not?}

\item{fill}{Color used to fill the bars (only used if bars are shown).}

\item{bar_width}{Relative width of the bars (only used if bars are shown).}

\item{bee_width}{Relative width of the beeswarms (only used if beeswarm shown).}

\item{bee_adjust}{Relative bandwidth adjustment factor used in
estimating the density of the beeswarms (only used if beeswarm shown).}

\item{viridis_args}{List of viridis color scale arguments used to control the
coloring of the beeswarm plot, see \code{?ggplot2::scale_color_viridis_c()}.
The default points to the global option \code{shapviz.viridis_args}, which
corresponds to \code{list(begin = 0.25, end = 0.85, option = "inferno")}.
These values are passed to \code{ggplot2::scale_color_viridis_c()}.
For example, to switch to a standard viridis scale, you can either change the default
with \code{options(shapviz.viridis_args = NULL)} or set \code{viridis_args = NULL}.}

\item{color_bar_title}{Title of color bar of the beeswarm plot.
Set to \code{NULL} to hide the color bar altogether.}

\item{show_numbers}{Should SHAP feature importances be printed?
Default is \code{FALSE}.}

\item{format_fun}{Function used to format SHAP feature importances
(only if \code{show_numbers = TRUE}). To change to scientific notation, use e.g.
\code{function(x) = prettyNum(x, scientific = TRUE)}.}

\item{number_size}{Text size of the numbers (if \code{show_numbers = TRUE}).}
}
\value{
A "ggplot" object representing an importance plot, or - if
\code{kind = "no"} - a named numeric vector of sorted SHAP feature importances.
}
\description{
This function provides two types of SHAP importance plots: a bar plot
and a beeswarm plot (sometimes called "SHAP summary plot").
The bar plot shows SHAP feature importances, calculated as the average absolute SHAP
value per feature.
The beeswarm plot displays SHAP values per feature, using min-max
scaled feature values on the color axis. Non-numeric features are transformed
to numeric by calling \code{data.matrix()} first.
For both types of plots, the features are sorted in decreasing
order of importance. The two types of plots can also be combined.
}
\section{Methods (by class)}{
\itemize{
\item \code{sv_importance(default)}: Default method.

\item \code{sv_importance(shapviz)}: SHAP importance plot for an object of class "shapviz".

}}
\examples{
X_train <- data.matrix(iris[, -1])
dtrain <- xgboost::xgb.DMatrix(X_train, label = iris[, 1])
fit <- xgboost::xgb.train(data = dtrain, nrounds = 50)
x <- shapviz(fit, X_pred = X_train)
sv_importance(x)
sv_importance(x, kind = "beeswarm", show_numbers = TRUE)
sv_importance(x, kind = "no")

X <- data.frame(matrix(rnorm(1000), ncol = 20))
S <- as.matrix(X)
x2 <- shapviz(S, X)
sv_importance(x2)
sv_importance(x2, max_display = 5)
sv_importance(x2, max_display = 5, show_other = FALSE)
}
