% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/shapeR.R
\name{estimate.outline.reconstruction}
\alias{estimate.outline.reconstruction}
\title{Estimate the outline reconstruction based on Fourier/wavelet compared to the outlines that have not been transformed}
\usage{
estimate.outline.reconstruction(object, ...)
}
\arguments{
\item{object}{\code{\linkS4class{shapeR}} object}

\item{...}{Additional parameters to be passed to 'plot' and 'points'}
}
\value{
A list containing values
\itemize{
 \item w.dev.m a list for number of coefficients for mean error of wavelet reconstruction
 \item w.dev.sd a list for number of coefficients for standard deviation of wavelet reconstruction
 \item f.power.total Fourier power for number of Fourier harmonics
}
}
\description{
Estimate outline reconstruction using a different number of coefficients of wavelet and Fourier compared to the original otolith
}
\examples{
\dontrun{
data(otoliths)
estimate.outline.reconstruction(shape)}
}
\author{
Lisa Anne Libungan
}
\references{
Claude, J. (2008) Morphometrics with R. Springer. 316 p.
}

