% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{set.control.airwls}
\alias{set.control.airwls}
\title{Check and set the control parameters for the AIRWLS algorithm}
\usage{
set.control.airwls(
  normalize = TRUE,
  maxiter = 100,
  nstep = 1,
  stepsize = 0.1,
  eps = 1e-08,
  nafill = 1,
  tol = 1e-05,
  damping = 0.001,
  verbose = FALSE,
  frequency = 10,
  parallel = FALSE,
  nthreads = 1
)
}
\arguments{
\item{normalize}{if \code{TRUE}, normalize \code{U} and \code{V} to uncorrelated Gaussian \code{U} and upper triangular \code{V} with positive diagonal}

\item{maxiter}{maximum number of iterations}

\item{nstep}{number of IRWLS steps in each inner loop of AIRWLS}

\item{stepsize}{step-size parameter scaling each IRWLS step}

\item{eps}{how much shrinkage has to be introduced on extreme predictions lying outside of the data range}

\item{nafill}{how frequently the \code{NA} values are filled, by default \code{NA} values are filled at each iteration of the algorithm}

\item{tol}{tolerance threshold for the stopping criterion}

\item{damping}{regularization parameter which is added to the diagonal of the Hessian to ensure numerical stability}

\item{verbose}{if \code{TRUE}, print the optimization status (default \code{TRUE})}

\item{frequency}{how often the optimization status is printed (only if \code{verbose=TRUE})}

\item{parallel}{if \code{TRUE}, allows for parallel computing using the \code{C++} library \code{OpenMP}}

\item{nthreads}{number of cores to be used in parallel (only if \code{parallel=TRUE})}
}
\value{
A \code{list} of control parameters for the AIRWLS algorithm
}
\description{
Check if the input control parameters of the AIRWLS algorithm are allowed
and set them to default values if they are not. Returns a list of
well-defined control parameters.
}
\examples{
library(sgdGMF)

# Empty call
set.control.airwls()

# Parametrized call
set.control.airwls(maxiter = 100, nstep = 5, stepsize = 0.3)


}
