% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hotspot_classify.R
\name{hotspot_classify}
\alias{hotspot_classify}
\title{Classify hot-spots}
\usage{
hotspot_classify(
  data,
  time = NULL,
  period = NULL,
  start = NULL,
  cell_size = NULL,
  grid_type = "rect",
  collapse = FALSE,
  params = hotspot_classify_params(),
  quiet = FALSE
)
}
\arguments{
\item{data}{\code{\link[sf]{sf}} data frame containing points.}

\item{time}{Name of the column in \code{data} containing \code{Date} or
\code{POSIXt} values representing the date associated with each point. If
this argument is \code{NULL} and \code{data} contains a single column of
\code{Date} or \code{POSIXt} values, that column will be used
automatically.}

\item{period}{A character value containing a number followed by a unit of
time, e.g. for example, "12 months" or "3.5 days", where the unit of time
is one of second, minute, hour, day, week, month, quarter or year (or their
plural forms).}

\item{start}{A \code{Date} or \code{POSIXt} value specifying when the first
temporal period should start. If \code{NULL} (the default), the first
period will start at the beginning of the earliest date found in the data
(if \code{period} is specified in days, weeks, months, quarters or years)
or at the earliest time found in the data otherwise.}

\item{cell_size}{\code{numeric} value specifying the size of each equally
spaced grid cell, using the same units (metres, degrees, etc.) as used in
the \code{sf} data frame given in the \code{data} argument. If this
argument is \code{NULL} (the default), the cell size will be calculated
automatically (see Details).}

\item{grid_type}{\code{character} specifying whether the grid should be made
up of squares (\code{"rect"}, the default) or hexagons (\code{"hex"}).}

\item{collapse}{If the range of dates in the data is not a multiple of
\code{period}, the final period will be shorter than the others. In that
case, should this shorter period be collapsed into the penultimate period?}

\item{params}{A list of optional parameters that can affect the output. The
list can be produced most easily using the
\code{\link{hotspot_classify_params}} helper function.}

\item{quiet}{if set to \code{TRUE}, messages reporting the values of any
parameters set automatically will be suppressed. The default is
\code{FALSE}.}
}
\value{
An \code{\link[sf]{sf}} tibble of regular grid cells with
corresponding hot-spot classifications for each cell.

Hot-spots are spatial areas that contain more points than would be expected
by chance; cold-spots are areas that contain fewer points than would be
expected. Whether an area is a hot-spot can vary over time. This function
creates a space-time cube, determines whether an area is a hot-spot for each
of several consecutive time periods and uses that to classify areas according
to whether they are persistent, intermittent, emerging or former hot- or
cold-spots.
\subsection{Hot and cold spots}{

Hot- and cold-spots are identified by calculating the Getis-Ord
\ifelse{html}{\out{<i>G</i><sub><i>i</i></sub><sup>*</sup>}}{\eqn{G^*_i}}
(gi-star) or
\ifelse{html}{\out{<i>G</i><sub><i>i</i></sub><sup>*</sup>}}{\eqn{G_i}}
\eqn{Z}-score statistic for each cell in a regular grid for each time period.
Cells are classified as follows, using the parameters provided in the
\code{params} argument:
\itemize{
\item \emph{Persistent hot-/cold-spots} are cells that have been hot-/cold-spots
consistently over time. Formally: if the \emph{p}-value is less than
\code{critical_p} for at least \code{persistent_prop} proportion of time periods.
\item \emph{Emerging hot-/cold-spots} are cells that have become hot-/cold-spots
recently but were not previously. Formally: if the \emph{p}-value is less
than \code{critical_p} for at least \code{hotspot_prop} of time periods defined as
recent by \code{recent_prop} but the \emph{p}-value was \emph{not} less than
\code{critical_p} for at least \code{hotspot_prop} of time periods defined as
non-recent by \code{1 - recent_prop}.
\item \emph{Former hot-/cold-spots} are cells that used to be hot-/cold-spots but have
not been more recently. Formally: if the \emph{p}-value was less than
\code{critical_p} for at least \code{hotspot_prop} of time periods defined as
non-recent by \code{1 - recent_prop} but the \emph{p}-value was \emph{not} less than
\code{critical_p} for for at least \code{hotspot_prop} of time periods defined as
recent by \code{recent_prop}.
\item \emph{Intermittent hot-/cold-spots} are cells that have been hot-/cold-spots,
but not as frequently as persistent hotspots and not only during
recent/non-recent periods. Formally: if the \emph{p}-value is less than
\code{critical_p} for at least \code{hotspot_prop} of time periods but the cell is
not an emerging or former hotspot.
\item \emph{No pattern} if none of the above categories apply.
}
}

\subsection{Coverage of the output data}{

The grid produced by this function covers the convex hull of the input data
layer. This means the result may include
\ifelse{html}{\out{<i>G</i><sub><i>i</i></sub><sup>*</sup>}}{\eqn{G^*_i}} or
\ifelse{html}{\out{<i>G</i><sub><i>i</i></sub><sup>*</sup>}}{\eqn{G_i}}
values for cells that are outside the area for which data were provided,
which could be misleading. To handle this, consider cropping the output layer
to the area for which data are available. For example, if you only have crime
data for a particular district, crop the output dataset to the district
boundary using \code{\link[sf]{st_intersection}}.
}

\subsection{Automatic cell-size selection}{

If no cell size is given then the cell size will be set so that there are 50
cells on the shorter side of the grid. If the \code{data} SF object is projected
in metres or feet, the number of cells will be adjusted upwards so that the
cell size is a multiple of 100.
}
}
\description{
Classify cells in a grid based on changes in the clustering of points
(typically representing events) in a two-dimensional regular grid over time.
}
\references{
Chainey, S. (2020). \emph{Understanding Crime: Analyzing the Geography of
Crime}. Redlands, CA: ESRI.
}
