% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local-colocation-quotient-impl.R
\name{local_colocation}
\alias{local_colocation}
\title{Local indicator of Colocation Quotient}
\usage{
local_colocation(A, B, nb, wt, nsim)
}
\arguments{
\item{A}{a character or factor vector.}

\item{B}{a character or factor vector.}

\item{nb}{a neighbors list e.g. created by \code{\link[=st_knn]{st_knn()}} or \code{\link[=st_contiguity]{st_contiguity()}}}

\item{wt}{a weights list. Recommended that it is a Gaussian kernel weights list using an adaptive bandwidth e.g. created by \code{st_kernel_weights(nb, geometry, "gaussian", addaptive = TRUE)} that does not include the self.}

\item{nsim}{default \code{99}. An integer representing how many simulations to run for calculating the simulated p-values.}
}
\value{
a data frame with as many rows as observations in A and two times as many columns as unique values in B. Columns contain each unique value of B as well as the simulated p-value for each value of B.
}
\description{
The local indicator of the colocation quotient (LCLQ) is a Local Indicator of Spatial Association (LISA) that evaluates if a given observation's subcategory in A is colocated with subcategories in B. Like the CLQ, the LCLQ provides insight into the asymmetric relationships between subcategories of A and B (where B can also equal A) but at the local level.

The LCLQ is defined using Gaussian kernel weights and an adaptive bandwidth (see \code{\link[=st_kernel_weights]{st_kernel_weights()}}). However, any type of weights list can be used. Kernel weights are used to introduce a decay into the calculation of the CLQ. This ensures that points nearer to the focal point have more influence than those that are more distant.
}
\details{
The LCLQ is defined as \eqn{LCLQ_{A_i \to B} = \frac{N_{A_i \to B}}{N_B / (N - 1)}} where \eqn{N_{A_i \to B} = \sum_{j = 1(j \ne i)}^{N}(\frac{w_{ij}f_{ij}}{\sum_{j = 1(j \ne i)}^{N}w_{ij}})}. And the weights matrix, wij, uses adaptive bandwidth Gaussian kernel weights.

LCLQ is only calculated for those subcategories which are present in the neighbor list. If a subcategory is not present, then the resultant LCLQ and simulated p-value will be \code{NA}.
}
\examples{
A <- guerry$main_city
B <- guerry$region
geo <- sf::st_centroid(sf::st_geometry(guerry))
nb <- include_self(st_knn(geo, 5))
wt <- st_kernel_weights(nb, geo, "gaussian", adaptive = TRUE)
res <- local_colocation(A, B, nb, wt, 9)
tail(res)
}
\references{
{Fahui Wang, Yujie Hu, Shuai Wang & Xiaojuan Li (2017) Local Indicator of Colocation Quotient with a Statistical Significance Test: Examining Spatial Association of Crime and Facilities, The Professional Geographer, 69:1, 22-31, \doi{10.1080/00330124.2016.1157498}}
}
