% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_extract.R
\name{st_collection_extract}
\alias{st_collection_extract}
\alias{st_collection_extract}
\alias{st_collection_extract.sfg}
\alias{st_collection_extract}
\alias{st_collection_extract.sfc}
\alias{st_collection_extract}
\alias{st_collection_extract.sf}
\title{Given an object with geometries of type \code{GEOMETRY} or \code{GEOMETRYCOLLECTION},
return an object consisting only of elements of the specified type.}
\usage{
st_collection_extract(x, type = c("POLYGON", "POINT", "LINESTRING"),
  warn = FALSE)

\method{st_collection_extract}{sfg}(x, type = c("POLYGON", "POINT",
  "LINESTRING"), warn = FALSE)

\method{st_collection_extract}{sfc}(x, type = c("POLYGON", "POINT",
  "LINESTRING"), warn = FALSE)

\method{st_collection_extract}{sf}(x, type = c("POLYGON", "POINT",
  "LINESTRING"), warn = FALSE)
}
\arguments{
\item{x}{an object of class \code{sf}, \code{sfc} or \code{sfg} that has
mixed geometry (\code{GEOMETRY} or \code{GEOMETRYCOLLECTION}).}

\item{type}{character; one of "POLYGON", "POINT", "LINESTRING"}

\item{warn}{logical; if \code{TRUE}, warn if attributes are assigned to
sub-geometries when casting (see \code{\link{st_cast}})}
}
\value{
An object having the same class as \code{x}, with geometries
consisting only of elements of the specified type.
For \code{sfg} objects, an \code{sfg} object is returned if there is only
one geometry of the specified type, otherwise the geometries are combined
into an \code{sfc} object of the relevant type. If any subgeometries in the
input are MULTI, then all of the subgeometries in the output will be MULTI.
}
\description{
Similar to ST_CollectionExtract in PostGIS. If there are no sub-geometries
of the specified type, an empty geometry is returned.
}
\examples{
pt <- st_point(c(1, 0))
ls <- st_linestring(matrix(c(4, 3, 0, 0), ncol = 2))
poly1 <- st_polygon(list(matrix(c(5.5, 7, 7, 6, 5.5, 0, 0, -0.5, -0.5, 0), ncol = 2)))
poly2 <- st_polygon(list(matrix(c(6.6, 8, 8, 7, 6.6, 1, 1, 1.5, 1.5, 1), ncol = 2)))
multipoly <- st_multipolygon(list(poly1, poly2))

i <- st_geometrycollection(list(pt, ls, poly1, poly2))
j <- st_geometrycollection(list(pt, ls, poly1, poly2, multipoly))

st_collection_extract(i, "POLYGON")
st_collection_extract(i, "POINT")
st_collection_extract(i, "LINESTRING")

## A GEOMETRYCOLLECTION
aa <- rbind(st_sf(a=1, geom = st_sfc(i)),
			st_sf(a=2, geom = st_sfc(j)))

## With sf objects
st_collection_extract(aa, "POLYGON")
st_collection_extract(aa, "LINESTRING")
st_collection_extract(aa, "POINT")

## With sfc objects
st_collection_extract(st_geometry(aa), "POLYGON")
st_collection_extract(st_geometry(aa), "LINESTRING")
st_collection_extract(st_geometry(aa), "POINT")

## A GEOMETRY of single types
bb <- rbind(
	st_sf(a = 1, geom = st_sfc(pt)),
	st_sf(a = 2, geom = st_sfc(ls)),
	st_sf(a = 3, geom = st_sfc(poly1)),
	st_sf(a = 4, geom = st_sfc(multipoly))
)

st_collection_extract(bb, "POLYGON")

## A GEOMETRY of mixed single types and GEOMETRYCOLLECTIONS
cc <- rbind(aa, bb)

st_collection_extract(cc, "POLYGON")

}
