% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom.R, R/valid.R
\name{geos_query}
\alias{geos_query}
\alias{st_dimension}
\alias{geos_query}
\alias{st_is_simple}
\alias{geos_query}
\alias{st_is_valid}
\title{Dimension, simplicity or validity queries on simple feature geometries}
\usage{
st_dimension(x, NA_if_empty = TRUE)

st_is_simple(x)

st_is_valid(x, NA_on_exception = TRUE, reason = FALSE)
}
\arguments{
\item{x}{object of class \code{sf}, \code{sfc} or \code{sfg}}

\item{NA_if_empty}{logical; if TRUE, return NA for empty geometries}

\item{NA_on_exception}{logical; if TRUE, for polygons that would otherwise raise a GEOS error (exception, e.g. for a POLYGON having more than zero but less than 4 points, or a LINESTRING having one point) return an \code{NA} rather than raising an error, and suppress warning messages (e.g. about self-intersection); if FALSE, regular GEOS errors and warnings will be emitted.}

\item{reason}{logical; if \code{TRUE}, return a character with, for each geometry, the reason for invalidity, \code{NA} on exception, or \code{"Valid Geometry"} otherwise.}
}
\value{
st_dimension returns a numeric vector with 0 for points, 1 for lines, 2 for surfaces, and, if \code{NA_if_empty} is \code{TRUE}, \code{NA} for empty geometries.

st_is_simple returns a logical vector, indicating for each geometry whether it is simple (e.g., not self-intersecting)

\code{st_is_vlaid} returns a logical vector indicating for each geometries of \code{x} whether it is valid.
}
\description{
Dimension, simplicity or validity queries on simple feature geometries
}
\examples{
x = st_sfc(
	st_point(0:1), 
	st_linestring(rbind(c(0,0),c(1,1))), 
	st_polygon(list(rbind(c(0,0),c(1,0),c(0,1),c(0,0)))),
	st_multipoint(),
	st_linestring(),
	st_geometrycollection())
st_dimension(x)
st_dimension(x, FALSE)
ls = st_linestring(rbind(c(0,0), c(1,1), c(1,0), c(0,1)))
st_is_simple(st_sfc(ls, st_point(c(0,0))))
p1 = st_as_sfc("POLYGON((0 0, 0 10, 10 0, 10 10, 0 0))")
st_is_valid(p1)
st_is_valid(st_sfc(st_point(0:1), p1[[1]]), reason = TRUE)
}
