% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db.R
\name{st_write_db}
\alias{st_write_db}
\title{Write simple feature table to a spatial database}
\usage{
st_write_db(conn = NULL, obj, table = substitute(obj),
  geom_name = "wkb_geometry", ..., drop_table = FALSE, try_drop = FALSE,
  append = FALSE, binary = TRUE, debug = FALSE)
}
\arguments{
\item{conn}{open database connection}

\item{obj}{object of class \code{sf}}

\item{table}{name for the table in the database}

\item{geom_name}{name of the geometry column in the database}

\item{...}{arguments passed on to \code{dbWriteTable}}

\item{drop_table}{logical; should \code{table} be dropped first?}

\item{try_drop}{logical; should we try() to drop \code{table} first?}

\item{append}{logical; append to table? (NOTE: experimental, might not work)}

\item{binary}{logical; use well-known-binary for transfer?}

\item{debug}{logical; print SQL statements to screen before executing them.}
}
\description{
Write simple feature table to a spatial database
}
\examples{
if (Sys.getenv("USER") \%in\% c("travis", "edzer")) {
  library(sp)
  data(meuse)
  sf = st_as_sf(meuse, coords = c("x", "y"), crs = 28992)
  library(RPostgreSQL)
  conn = dbConnect(PostgreSQL(), dbname = "postgis")
  st_write_db(conn, sf, "meuse_tbl", drop_table = FALSE)
}
}

