% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R, R/db.R
\name{st_read}
\alias{st_read}
\alias{st_read_db}
\title{Read simple features or layers from file or database}
\usage{
st_read(dsn, layer, ..., options = NULL, quiet = FALSE, iGeomField = 1L,
  type = 0, promote_to_multi = TRUE,
  stringsAsFactors = default.stringsAsFactors())

st_read_db(conn = NULL, table, query = paste("select * from ", table, ";"),
  geom_column = NULL, EWKB, ...)
}
\arguments{
\item{dsn}{data source name (interpretation varies by driver - for some drivers, dsn is a file name, but may also be a folder, or contain the name and access credentials of a database)}

\item{layer}{layer name (varies by driver, may be a file name without extension); in case \code{layer} is missing, \code{st_read} will read the first layer of \code{dsn}, give a warning and (unless \code{quiet = TRUE}) print a message when there are multiple layers, or give an error if there are no layers in \code{dsn}.}

\item{...}{parameter(s) passed on to \link{st_as_sf}}

\item{options}{character; driver dependent dataset open options, multiple options supported.}

\item{quiet}{logical; suppress info on name, driver, size and spatial reference, or signaling no or multiple layers}

\item{iGeomField}{integer; in case of multiple geometry fields, which one to take?}

\item{type}{integer; ISO number of desired simple feature type; see details. If left zero, in case of mixed feature geometry types, conversion to the highest numeric type value found will be attempted.}

\item{promote_to_multi}{logical; in case of a mix of LineString and MultiLineString, or of Polygon and MultiPolygon, convert all to the Multi variety; defaults to \code{TRUE}}

\item{stringsAsFactors}{logical; logical: should character vectors be converted to factors?  The `factory-fresh' default is \code{TRUE}, but this can be changed by setting \code{options(stringsAsFactors = FALSE)}.}

\item{conn}{open database connection}

\item{table}{table name}

\item{query}{SQL query to select records}

\item{geom_column}{character or integer: indicator of name or position of the geometry column; if not provided, the last column of type character is chosen}

\item{EWKB}{logical; is the WKB is of type EWKB? defaults to TRUE if \code{conn} is of class code{PostgreSQLConnection} or \code{PqConnection}}
}
\value{
object of class \link{sf} when a layer was succesfully read; in case argument \code{layer} is missing and data source \code{dsn} does not contain a single layer, an object of class \code{sf_layers} is returned with the layer names, each with their geometry type(s). Note that the number of layers may also be zero.
}
\description{
Read simple features from file or database, or retrieve layer names and their geometry type(s)

Read PostGIS table directly through DBI and RPostgreSQL interface, converting binary
}
\details{
for iGeomField, see also \url{https://trac.osgeo.org/gdal/wiki/rfc41_multiple_geometry_fields}; for \code{type} values see \url{https://en.wikipedia.org/wiki/Well-known_text#Well-known_binary}, but note that not every target value may lead to succesful conversion. The typical conversion from POLYGON (3) to MULTIPOLYGON (6) should work; the other way around (type=3), secondary rings from MULTIPOLYGONS may be dropped without warnings.

in case geom_column is missing: if table is missing, this function will try to read the name of the geometry column from table \code{geometry_columns}, in other cases, or when this fails, the geom_column is assumed to be the last column of mode character. If table is missing, the SRID cannot be read and resolved into a proj4string by the database, and a warning will be given.
}
\note{
The use of \code{system.file} in examples make sure that examples run regardless where R is installed: typical users will not use \code{system.file} but give the file name directly, either with full path or relative to the current working directory (see \link{getwd}). "Shapefiles" consist of several files with the same basename that reside in the same directory, only one of them having extension \code{.shp}.
}
\examples{
if (Sys.getenv("USER") \%in\% c("edzer", "travis")) { # load meuse to postgis
 library(sp)
 example(meuse, ask = FALSE, echo = FALSE)
 st_write(st_as_sf(meuse), "PG:dbname=postgis", "meuse", 
     layer_options = "OVERWRITE=true")
 (s = st_read("PG:dbname=postgis", "meuse"))
 summary(s)
}
# nc = st_read(system.file("gpkg/nc.gpkg", package="sf"))
nc = st_read(system.file("shape/nc.shp", package="sf"))
summary(nc)
if (Sys.getenv("USER") \%in\% c("travis", "edzer")) {
  library(RPostgreSQL)
  conn = dbConnect(PostgreSQL(), dbname = "postgis")
  x = st_read_db(conn, "meuse", query = "select * from meuse limit 3;")
  print(st_crs(x)) # SRID resolved by the database, not by GDAL!
  dbDisconnect(conn)
}
}

