% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/options.R
\name{clone_and_merge}
\alias{clone_and_merge}
\title{Create a local, altered copy of an options manager}
\usage{
clone_and_merge(options, ...)
}
\arguments{
\item{options}{A function as returned by \code{\link{options_manager}} or \code{clone_and_merge}.}

\item{...}{Options to be merged, in the form of \code{[name]=[value]} pairs.}
}
\value{
A option manager like \code{options}, with possibly different settings.
}
\description{
Local options management.
}
\section{Details}{

This function creates a copy of the options manager \code{options}, with the same defaults.
However, the current settings may be altered by passing extra arguments. Its intended use
is to allow for easy merging of local options with global settings in a function call.

Some more examples can be found in the vignette: \code{vignette('settings',package='options')}.
}
\examples{
# Create global option manager.
opt <- options_manager(foo=1,bar='a')

# create an altered copy
loc_opt <- clone_and_merge(opt, foo=2)

# this has no effect on the 'global' version
opt()
# but the local version is different
loc_opt()

# we alter the global version and reset the local version
opt(foo=3)
reset(loc_opt)
opt()
loc_opt()
}
\seealso{
\code{\link{options_manager}}, \code{\link{reset}}, \code{\link{defaults}}
}

