% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetWrapper_ExponentSet.R
\name{ExponentSet}
\alias{ExponentSet}
\title{Set of Exponentiations}
\description{
ExponentSet class for symbolic exponentiation of mathematical sets.
}
\details{
The purpose of this class is to provide a symbolic representation for the exponentiation of sets that
cannot be represented in a simpler class. Whilst this is not an abstract class, it is not recommended to construct
this class directly but via the set operation methods.
}
\seealso{
Set operations: \link{setunion}, \link{setproduct}, \link{setpower}, \link{setcomplement}, \link{setsymdiff},  \link{powerset}, \link{setintersect}

Other wrappers: 
\code{\link{ComplementSet}},
\code{\link{PowersetSet}},
\code{\link{ProductSet}},
\code{\link{UnionSet}}
}
\concept{wrappers}
\section{Super classes}{
\code{\link[set6:Set]{set6::Set}} -> \code{\link[set6:SetWrapper]{set6::SetWrapper}} -> \code{\link[set6:ProductSet]{set6::ProductSet}} -> \code{ExponentSet}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{power}}{Returns the power that the wrapped set is raised to.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ExponentSet$new()}}
\item \href{#method-strprint}{\code{ExponentSet$strprint()}}
\item \href{#method-contains}{\code{ExponentSet$contains()}}
\item \href{#method-clone}{\code{ExponentSet$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="add">}\href{../../set6/html/Set.html#method-add}{\code{set6::Set$add()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="print">}\href{../../set6/html/Set.html#method-print}{\code{set6::Set$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="remove">}\href{../../set6/html/Set.html#method-remove}{\code{set6::Set$remove()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="Set" data-id="summary">}\href{../../set6/html/Set.html#method-summary}{\code{set6::Set$summary()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="SetWrapper" data-id="equals">}\href{../../set6/html/SetWrapper.html#method-equals}{\code{set6::SetWrapper$equals()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="set6" data-topic="SetWrapper" data-id="isSubset">}\href{../../set6/html/SetWrapper.html#method-isSubset}{\code{set6::SetWrapper$isSubset()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{ExponentSet} object. It is not recommended to construct this
class directly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExponentSet$new(set, power)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{set}}{\link{Set} to wrap.}

\item{\code{power}}{numeric. Power to raise Set to.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{ExponentSet} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-strprint"></a>}}
\if{latex}{\out{\hypertarget{method-strprint}{}}}
\subsection{Method \code{strprint()}}{
Creates a printable representation of the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExponentSet$strprint(n = 2)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{numeric. Number of elements to display on either side of ellipsis when printing.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character string representing the object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-contains"></a>}}
\if{latex}{\out{\hypertarget{method-contains}{}}}
\subsection{Method \code{contains()}}{
Tests if elements \code{x} are contained in \code{self}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExponentSet$contains(x, all = FALSE, bound = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{\link{Set} or vector of \link{Set}s.}

\item{\code{all}}{logical. If \code{FALSE} tests each \code{x} separately. Otherwise returns \code{TRUE} only if all \code{x} pass test.}

\item{\code{bound}}{logical}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
If \code{all == TRUE} then returns \code{TRUE} if all \code{x} are contained in \code{self},
otherwise \code{FALSE}. If \code{all == FALSE} returns a vector of logicals corresponding to the
length of \code{x}, representing if each is contained in \code{self}. If \code{bound == TRUE} then an
element is contained in \code{self} if it is on or within the (possibly-open) bounds of \code{self},
otherwise \code{TRUE} only if the element is within \code{self} or the bounds are closed.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExponentSet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
