% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Set_FuzzySet_FuzzyTuple.R
\name{FuzzyTuple}
\alias{FuzzyTuple}
\title{Mathematical Fuzzy Tuple}
\value{
R6 object of class FuzzyTuple inheriting from \link{FuzzySet}.
}
\description{
A general FuzzyTuple object for mathematical fuzzy tuples, inheriting from \code{FuzzySet}.
}
\details{
Fuzzy tuples generalise standard mathematical tuples to allow for fuzzy relationships. Whereas a
standard, or crisp, tuple assumes that an element is either in a tuple or not, a fuzzy tuple allows
an element to be in a tuple to a particular degree, known as the membership function, which
quantifies the inclusion of an element by a number in [0, 1]. Thus a (crisp) tuple is a
fuzzy tuple where all elements have a membership equal to \eqn{1}. Similarly to \link{Tuple}s, elements
do not need to be unique and the ordering does matter, \link{FuzzySet}s are special cases where the ordering
does not matter and elements must be unique.
}
\section{Constructor}{
 \code{FuzzyTuple$new(..., elements = NULL, membership = rep(1, length(elements)))}
}

\section{Constructor Arguments}{

\tabular{lll}{
\strong{Argument} \tab \strong{Type} \tab \strong{Details} \cr
\code{...} \tab ANY \tab Alternating elements and membership, see constructor details. \cr
\code{elements} \tab ANY \tab Elements in the set, see constructor details. \cr
\code{membership} \tab numeric \tab Corresponding membership of the elements, see constructor details. \cr

}
}

\section{Constructor Details}{
 \code{FuzzyTuple}s can be constructed in one of two ways, either by supplying the elements and their membership in alternate order, or by providing a list of elements to \code{elements} and a list of respective memberships to \code{membership}, see examples.
}

\section{Public Fields}{

\tabular{ll}{
\strong{Field} \tab \strong{Link} \cr

\code{class} \tab \link{class} \cr
\code{elements} \tab \link{elements} \cr
\code{length} \tab \link{length} \cr
\code{lower} \tab \link{lower} \cr
\code{upper} \tab \link{upper} \cr
\code{max} \tab \link{max} \cr
\code{min} \tab \link{min} \cr
\code{range} \tab \link{range} \cr
\code{properties} \tab \link{properties} \cr
\code{traits} \tab \link{traits} \cr
\code{type} \tab \link{type} \cr
\code{universe} \tab \link{universe}
}
}

\section{Public Methods}{

\tabular{ll}{
\strong{Fuzzy Methods} \tab \strong{Link} \cr
\code{membership(element = NULL)} \tab \link{membership} \cr
\code{alphaCut(alpha, strong = FALSE, create = FALSE)} \tab \link{alphaCut} \cr
\code{support(create = FALSE)} \tab \link{support} \cr
\code{core(create = FALSE)} \tab \link{core} \cr
\code{inclusion(element)} \tab \link{inclusion} \cr
\tab \cr \tab \cr \tab \cr

\strong{Comparison Methods} \tab \strong{Link} \cr
\code{contains(x, all = FALSE, bound = NULL)} \tab \link{contains} \cr
\code{equals(x, all = FALSE)} \tab \link{equals} \cr
\code{isSubset(x, proper = FALSE, all = FALSE)} \tab \link{isSubset} \cr
\tab \cr \tab \cr \tab \cr
\strong{Mathematical Methods} \tab \strong{Link} \cr
\code{absComplement()} \tab \link{absComplement} \cr
\tab \cr \tab \cr \tab \cr
\strong{Representation Methods} \tab \strong{Link} \cr
\code{strprint(n = 2)} \tab \link{strprint} \cr
\code{print(n = 2)} \tab \link{print} \cr
\code{summary(n = 2)} \tab \link{summary} \cr
}
}

\examples{
# Different constructors
FuzzyTuple$new(1, 0.5, 2, 1, 3, 0)
FuzzyTuple$new(elements = 1:3, membership = c(0.5, 1, 0))

# Crisp sets are a special case FuzzyTuple
# Note membership defaults to full membership
FuzzyTuple$new(elements = 1:5) == Tuple$new(1:5)

f = FuzzyTuple$new(1, 0.2, 2, 1, 3, 0)
f$membership()
f$alphaCut(0.3)
f$core()
f$inclusion(0)
f$membership(0)
f$membership(1)

# Elements can be duplicated, and with different memberships,
#  although this is not necessarily sensible.
FuzzyTuple$new(1, 0.1, 1, 1)

# More important is ordering.
FuzzyTuple$new(1, 0.1, 2, 0.2) != FuzzyTuple$new(2, 0.2, 1, 0.1)
FuzzySet$new(1, 0.1, 2, 0.2) == FuzzySet$new(2, 0.2, 1, 0.1)

}
\seealso{
Other sets: 
\code{\link{ConditionalSet}},
\code{\link{FuzzySet}},
\code{\link{Interval}},
\code{\link{Set}},
\code{\link{Tuple}}
}
\concept{sets}
