% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratify_data.R
\name{stratify_data}
\alias{stratify_data}
\title{Split data by stratum}
\usage{
stratify_data(
  data,
  curve_params,
  noise_params,
  strata_varnames = "",
  curve_strata_varnames = NULL,
  noise_strata_varnames = NULL,
  antigen_isos = get_biomarker_levels(data)
)
}
\arguments{
\item{strata_varnames}{\code{\link[=character]{character()}}
vector of names of variables in \code{data} to stratify by}
}
\value{
a \code{"biomarker_data_and_params.list"} object
(a \link{list} with extra attributes \code{"strata"}, \code{"antigen_isos"}, etc)
}
\description{
Split biomarker data, decay curve parameters,
and noise parameters
to prepare for stratified incidence estimation.
}
\examples{
\dontrun{
library(dplyr)

xs_data <-
  sees_pop_data_pk_100

curve <-
  typhoid_curves_nostrat_100 |>
  filter(antigen_iso \%in\% c("HlyE_IgA", "HlyE_IgG"))

noise <-
  example_noise_params_pk

stratified_data =
  stratify_data(
   data = xs_data,
   curve_params = curve,
   noise_params = noise,
   strata_varnames = "catchment",
   curve_strata_varnames = NULL,
   noise_strata_varnames = NULL
   )
}
}
\keyword{internal}
