% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratify_data.R
\name{stratify_data}
\alias{stratify_data}
\title{Split data by stratum}
\usage{
stratify_data(
  data,
  curve_params,
  noise_params,
  strata_varnames = "",
  curve_strata_varnames = NULL,
  noise_strata_varnames = NULL,
  antigen_isos = data \%>\% attr("antigen_isos")
)
}
\arguments{
\item{curve_params}{a \code{\link[=data.frame]{data.frame()}} containing MCMC samples of parameters
from the Bayesian posterior distribution of a longitudinal decay curve model.
The parameter columns must be named:
\itemize{
\item \code{antigen_iso}: a \code{\link[=character]{character()}} vector indicating antigen-isotype
combinations
\item \code{iter}: an \code{\link[=integer]{integer()}} vector indicating MCMC sampling iterations
\item \code{y0}: baseline antibody level at $t=0$ ($y(t=0)$)
\item \code{y1}: antibody peak level (ELISA units)
\item \code{t1}: duration of infection
\item \code{alpha}: antibody decay rate
(1/days for the current longitudinal parameter sets)
\item \code{r}: shape factor of antibody decay
}}

\item{noise_params}{a \code{\link[=data.frame]{data.frame()}} (or \code{\link[tibble:tibble]{tibble::tibble()}})
containing the following variables,
specifying noise parameters for each antigen isotype:
\itemize{
\item \code{antigen_iso}: antigen isotype whose noise parameters are being specified
on each row
\item \code{nu}: biological noise
\item \code{eps}: measurement noise
\item \code{y.low}: lower limit of detection for the current antigen isotype
\item \code{y.high}: upper limit of detection for the current antigen isotype
}}

\item{strata_varnames}{\code{\link[=character]{character()}} vector of names of variables in \code{data} to stratify by}

\item{curve_strata_varnames}{A subset of \code{strata}.
Values must be variable names in \code{curve_params}. Default = "".}

\item{noise_strata_varnames}{A subset of \code{strata}.
Values must be variable names in \code{noise_params}. Default = "".}

\item{antigen_isos}{Character vector with one or more antibody names. Values must match \code{pop_data}}
}
\value{
a \code{"biomarker_data_and_params.list"} object (a \link{list} with extra attributes \code{"strata"}, \code{"antigen_isos"}, etc)
}
\description{
Split biomarker data, decay curve parameters, and noise parameters
to prepare for stratified incidence estimation.
}
\examples{
\dontrun{
library(dplyr)

xs_data <-
  sees_pop_data_pk_100

curve <-
  typhoid_curves_nostrat_100 \%>\%
  filter(antigen_iso \%in\% c("HlyE_IgA", "HlyE_IgG"))

noise <-
  example_noise_params_pk

stratified_data =
  stratify_data(
   data = xs_data,
   curve_params = curve,
   noise_params = noise,
   strata_varnames = "catchment",
   curve_strata_varnames = NULL,
   noise_strata_varnames = NULL
   )
}
}
\keyword{internal}
