% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ser_permutation_vector.R
\name{ser_permutation_vector}
\alias{ser_permutation_vector}
\alias{c.ser_permutation_vector}
\alias{rev.ser_permutation_vector}
\alias{get_method}
\alias{length.ser_permutation_vector}
\alias{print.ser_permutation_vector}
\alias{summary.ser_permutation_vector}
\title{Class ser_permutation_vector -- A Single Permutation Vector for Seriation}
\usage{
ser_permutation_vector(x, method = NULL)

\method{c}{ser_permutation_vector}(..., recursive = FALSE)

\method{rev}{ser_permutation_vector}(x)

get_method(x, printable = FALSE)

\method{length}{ser_permutation_vector}(x)

\method{print}{ser_permutation_vector}(x, ...)

\method{summary}{ser_permutation_vector}(object, ...)
}
\arguments{
\item{x, object}{an object which contains a permutation vector (currently an
integer vector or an object of class \link{hclust}). The value \code{NA}
creates an identity permutation.}

\item{method}{a string representing the method used to obtain the
permutation vector.}

\item{...}{further arguments.}

\item{recursive}{ignored}

\item{printable}{a logical; prints "unknown" instead of \code{NULL} for non-existing methods.}
}
\value{
An object of class \code{ser_permutation_vector}.
}
\description{
The class \code{ser_permutation_vector}
represents a single permutation vector.
}
\details{
A permutation vector
maps a set of \eqn{n} objects \eqn{\{O_1, O_2, ..., O_n\}}{{O_1, O_2, ..., O_n}} onto itself.
In \pkg{seriation} we represent a permutation \eqn{\pi}{\pi}
as a vector which lists the objects in their permuted order.
For example, the permutation vector \eqn{\langle3, 1, 2\rangle}{<3, 1, 2>} indicates that in first position is the object with index 3 then the object with index 1 and finally
the object with index 2.
A permutation vector can be extracted from a permutation vector object
via \code{\link[=get_order]{get_order()}}. Such a permutation vector can be directly used
to subset the list of original objects with \code{"["} to apply the permutation.
\strong{Note:} An alternative way to specify a permutation is via a list of the ranks
of the objects after permutation (see \code{\link[=get_rank]{get_rank()}}).

\code{ser_permutation_vector} objects are usually packed into
a \link{ser_permutation} object
which is a collection of \eqn{k} permutation vectors for \eqn{k}-mode data.

The constructor \code{ser_permutation_vector()}
checks if the permutation vector is valid
(i.e. if all integers occur exactly once).
}
\examples{
p <- ser_permutation_vector(sample(10), "random")
p

## some methods
length(p)
get_method(p)
get_order(p)
get_rank(p)
get_permutation_matrix(p)

r <- rev(p)
r
get_order(r)

## create a identity permutation vector (with unknown length)
ip <- ser_permutation_vector(NA)
ip

}
\seealso{
Other permutation: 
\code{\link{get_order}()},
\code{\link{permutation_vector2matrix}()},
\code{\link{permute}()},
\code{\link{ser_dist}()},
\code{\link{ser_permutation}()}
}
\author{
Michael Hahsler
}
\concept{permutation}
\keyword{classes}
