% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotPedComp.R
\name{CalcCorners}
\alias{CalcCorners}
\title{Corner coordinates}
\usage{
CalcCorners(count)
}
\arguments{
\item{count}{a length 5 named vector: 'Total', 'Match', 'Mismatch',
'P1only', and 'P2only'.}
}
\value{
a 4x4 matrix with columns "xleft", "xright", "ybottom", "ytop" (as
  used by \code{\link{rect}}) and rows "Ped1", "Ped2", "Mismatch", "Match".
}
\description{
Calculate corner coordinates for each of the four rectangles in
 a square Venn diagram
}
\details{
the bottom-left corner of the Ped1 square is (0,0); offset is done
  by \code{\link{VennSquares}}. The size of the Ped1 and Ped2 squares is
  proportional to their count, i.e. N1 = count["Total"] -
  count["P2only"], and the length of each size thus proportional to the
  \code{sqrt} of that.

  The x-location of the Ped2 square is a function of the amount of overlap
  (Match + Mismatch): if 0% overlap then coco["Ped2","xleft"] =
  coco["Ped1", "xright"], if 100% overlap then coco["Ped2","xright"] =
  coco["Ped1", "xright"]; and proportional in-between these two extremes.

  The overlap area between Ped1 and Ped2 is split into Mismatch (bottom) and
  Match (top).
}
\seealso{
\code{\link{PlotPedComp}, \link{VennSquares}}
}
\keyword{internal}
