% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tally.R
\name{tally_se}
\alias{tally_se}
\title{tally/count standard interface.}
\usage{
tally_se(x, wt = NULL, sort = FALSE)
}
\arguments{
\item{x}{data.frame to tally/count}

\item{wt}{character optional column name containing row-weights (passed to count/tally)}

\item{sort}{logical if TRUE sort result in descending order}
}
\value{
.data with only selected columns
}
\description{
Add a new column named "n" with (optionally per-group) sums/counts.
}
\details{
Note: \code{dplyr::count}, \code{dplyr::add_count},
\code{dplyr::tally}, and \code{dplyr::add_tally} are not \code{S3}
methods, so it may not be practical to re-dispatch \code{seplyr} calls
to these \code{dplyr} implementations.
}
\examples{

datasets::mtcars \%>\% tally_se()
datasets::mtcars \%>\% tally_se(wt = "cyl")

}
\seealso{
\code{\link[dplyr]{tally}}
}
