% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/others.R
\name{compute_PicaultRenault_scores}
\alias{compute_PicaultRenault_scores}
\title{Compute scores using the Picault-Renault lexicon}
\usage{
compute_PicaultRenault_scores(x, min_ngram = 2, return_dfm = FALSE)
}
\arguments{
\item{x}{a \link[quanteda:corpus]{quanteda::corpus} object.}

\item{min_ngram}{the minimum length of n-grams considered in the computation}

\item{return_dfm}{if \code{TRUE}, returns the scaled word-per-document score under
two \link{dfm}, on for the Monetary Policy and one for the Economic Condition
categories. If \code{FALSE}, returns the sum of all word scores per document.}
}
\value{
A matrix with two columns, indicating respectively the MP (Monetary
Policy) and EC (Economic Condition) scores of each document.
}
\description{
Computes Monetary Policy and Economic Condition scores using the
Picault-Renault lexicon for central bank communication.
}
\details{
The computation is done on a per-document basis, such as each
document is scored with a value between -1 and 1. This is relevant to the
computation of the denominator of the score.

It is possible to compute the score for paragraphs and sentences for a
\link[quanteda:corpus]{quanteda::corpus} segmented using \link[quanteda:corpus_reshape]{quanteda::corpus_reshape}. Segmenting a
corpus using \strong{quanteda}'s helpers retain track to which document each
paragraph/sentence belong. However, in that case, it is possible that
paragraphs or sentences are scored outside the (-1,1) interval. In any
case, the of the paragraph/sentences scores averaged over documents will be
contained in the (-1,1) interval.
}
\examples{
\donttest{# on documents
docs <- quanteda::corpus_reshape(ECB_press_conferences, "documents")
compute_PicaultRenault_scores(docs)

# on paragraphs
compute_PicaultRenault_scores(ECB_press_conferences)}
}
\references{
Picault, M. & Renault, T. (2017). \href{https://www.sciencedirect.com/science/article/abs/pii/S0261560617301808}{Words are not all created equal: A new measure of ECB communication}.
\emph{Journal of International Money and Finance}, 79, 136--156.
}
\seealso{
\link{PicaultRenault}
}
