% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures.R
\name{measures_fill}
\alias{measures_fill}
\title{Add and fill missing dates}
\usage{
measures_fill(sentomeasures, fill = "zero")
}
\arguments{
\item{sentomeasures}{a \code{sentomeasures} object created using \code{\link{sento_measures}}.}

\item{fill}{an element of \code{c("zero", "latest", NA)}; the first and last assume missing dates represent zero sentiment,
the second assumes missing dates represent constant sentiment.}
}
\value{
A modified \code{sentomeasures} object.
}
\description{
Adds missing dates between earliest and latest date of a \code{sentomeasures} object, such that time series
is continuous date-wise. Fills in these dates with either 0, the respective latest non-missing value or \code{NA}.
}
\examples{
data("usnews", package = "sentometrics")
data("list_lexicons", package = "sentometrics")
data("list_valence_shifters", package = "sentometrics")

# construct a sentomeasures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 500)
l <- setup_lexicons(list_lexicons[c("LM_en", "HENRY_en")], list_valence_shifters[["en"]])
ctr <- ctr_agg(howTime = c("equal_weight", "linear"), by = "day", lag = 7)
sentomeasures <- sento_measures(corpusSample, l, ctr)

# fill measures
f1 <- measures_fill(sentomeasures)
f2 <- measures_fill(sentomeasures, fill = "latest")
f3 <- measures_fill(sentomeasures, fill = NA)

}
\author{
Samuel Borms
}
