% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentomeasures.R
\name{scale.sentomeasures}
\alias{scale.sentomeasures}
\title{Scaling and centering of sentiment measures}
\usage{
\method{scale}{sentomeasures}(x, center = TRUE, scale = TRUE)
}
\arguments{
\item{x}{a \code{sentomeasures} object created using \code{\link{sento_measures}}.}

\item{center}{a \code{logical}, see documentation for the generic \code{\link{scale}}.}

\item{scale}{a \code{logical}, see documentation for the generic \code{\link{scale}}.}
}
\value{
A modified \code{sentomeasures} object, with the measures replaced by the scaled measures as well as updated
statistics.
}
\description{
Scales and centers the sentiment measures from a \code{sentomeasures} object, column-per-column. By default,
the measures are normalized. \code{NA}s are removed first.
}
\examples{
data("usnews")
data("lexicons")
data("valence")

# construct a sentomeasures object to start with
corpus <- sento_corpus(corpusdf = usnews)
corpusSample <- quanteda::corpus_sample(corpus, size = 500)
l <- setup_lexicons(lexicons[c("LM_eng", "HENRY_eng")], valence[["valence_eng"]])
ctr <- ctr_agg(howTime = c("equal_weight", "linear"), by = "year", lag = 3)
sentomeasures <- sento_measures(corpusSample, l, ctr)

# scale sentiment measures
scaled <- scale(sentomeasures)

}
\author{
Samuel Borms
}
