% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profanity_by.R
\name{profanity_by}
\alias{profanity_by}
\title{Profanity Rate By Groups}
\usage{
profanity_by(text.var, by = NULL, group.names, ...)
}
\arguments{
\item{text.var}{The text variable.  Also takes a \code{profanityr} or
\code{profanity_by} object.}

\item{by}{The grouping variable(s).  Default \code{NULL} uses the original
row/element indices; if you used a column of 12 rows for \code{text.var}
these 12 rows will be used as the grouping variable.  Also takes a single
grouping variable or a list of 1 or more grouping variables.}

\item{group.names}{A vector of names that corresponds to group.  Generally
for internal use.}

\item{\ldots}{Other arguments passed to \code{\link[sentimentr]{profanity}}.}
}
\value{
Returns a \pkg{data.table} with grouping variables plus:
\itemize{
  \item  element_id - The id number of the original vector passed to \code{profanity}
  \item  sentence_id - The id number of the sentences within each \code{element_id}
  \item  word_count - Word count \code{\link[base]{sum}}med by grouping variable
  \item  profanity_count - The number of profanities used by grouping variable
  \item  sd - Standard deviation (\code{\link[stats]{sd}}) of the sentence level profanity rate by grouping variable
  \item  ave_profanity - Profanity rate
}
}
\description{
Approximate the profanity of text by grouping variable(s).  For a
full description of the profanity detection algorithm see 
\code{\link[sentimentr]{profanity}}.  See \code{\link[sentimentr]{profanity}}
for more details about the algorithm, the profanity/valence shifter keys
that can be passed into the function, and other arguments that can be passed.
}
\section{Chaining}{

See the  \code{\link[sentimentr]{sentiment_by}} for details about \pkg{sentimentr} chaining.
}

\examples{
\dontrun{
bw <- sample(lexicon::profanity_alvarez, 4)
mytext <- c(
   sprintf('do you like this \%s?  It is \%s. But I hate really bad dogs', bw[1], bw[2]),
   'I am the best friend.',
   NA,
   sprintf('I \%s hate this \%s', bw[3], bw[4]),
   "Do you really like it?  I'm not happy"
)

## works on a character vector but not the preferred method avoiding the 
## repeated cost of doing sentence boundary disambiguation every time 
## `profanity` is run
profanity(mytext)
profanity_by(mytext)

## preferred method avoiding paying the cost 
mytext <- get_sentences(mytext)

profanity_by(mytext)
get_sentences(profanity_by(mytext))

(myprofanity <- profanity_by(mytext))
stats::setNames(get_sentences(profanity_by(mytext)),
    round(myprofanity[["ave_profanity"]], 3))

brady <- get_sentences(crowdflower_deflategate)
library(data.table)
bp <- profanity_by(brady)
crowdflower_deflategate[bp[ave_profanity > 0,]$element_id, ]

vulgars <- bp[["ave_profanity"]] > 0
stats::setNames(get_sentences(bp)[vulgars],
    round(bp[["ave_profanity"]][vulgars], 3))
    
bt <- data.table(crowdflower_deflategate)[, 
    source := ifelse(grepl('^RT', text), 'retweet', 'OP')][,
    belichick := grepl('\\\\bb[A-Za-z]+l[A-Za-z]*ch', text, ignore.case = TRUE)][]

prof_bel <- with(bt, profanity_by(text, by = list(source, belichick)))

plot(prof_bel)
}
}
\seealso{
Other profanity functions: \code{\link{profanity}}
}
\concept{profanity functions}
\keyword{bad-words}
\keyword{cursing,}
\keyword{cussing,}
\keyword{profanity,}
\keyword{vulgarity,}
