% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s2_angles.R
\name{s2_angles}
\alias{s2_angles}
\title{Extract sun angles from SAFE archives}
\usage{
s2_angles(
  infiles,
  outdir = ".",
  subdirs = NA,
  tmpdir = NA,
  rmtmp = TRUE,
  prod_type = c("SZA", "OZA", "SAA", "OAA"),
  res = "10m",
  method = "bilinear",
  format = "VRT",
  compress = "DEFLATE",
  bigtiff = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{infiles}{Full paths of the input SAFE folders.}

\item{outdir}{(optional) Full name of the output directory where
the files should be created (default: current directory).
\code{outdir} can bot be an existing or non-existing directory (in the
second case, its parent directory must exists).
If it is a relative path, it is expanded from the directory of \code{infile}.}

\item{subdirs}{(optional) Logical: if TRUE, different output products are
placed in separated \code{outdir} subdirectories; if FALSE, they are placed in
\code{outdir} directory; if NA (default), subdirectories are created only if
\code{prod_type} has length > 1.}

\item{tmpdir}{(optional) Path where intermediate files will be created.
Default is a temporary directory.
If \code{tmpdir} is a non-empty folder, a random subdirectory will be used.}

\item{rmtmp}{(optional) Logical: should temporary files be removed?
(Default: TRUE).}

\item{prod_type}{(optional) Vector of types (angles) to be produced as outputs.
Default is all the possible types
(\code{"SZA"} for Sun Angles Grid at Zenith,
\code{"SAA"} for Sun Angles Grid at Azimuth,
\code{"OZA"} for Viewing Incidence Angles at Zenith averaged Grid,
\code{"OAA"} for Viewing Incidence Angles at Azimuth averaged Grid).}

\item{res}{(optional) Spatial resolution (one between \code{'10m'}, \code{'20m'} or
\code{'60m'}); default is \code{'10m'}.}

\item{method}{(optional) A method used to resample the output rasters
(accepted values are valid values accepted by \code{-r} option of gdalwarp).
Default is \code{"bilinear"} (linear interpolation).}

\item{format}{(optional) Format of the output file (in a
format recognised by GDAL). Default value is \code{"VRT"} (Virtual Raster).}

\item{compress}{(optional) In the case a GeoTIFF format is
chosen, the compression indicated with this parameter is used.}

\item{bigtiff}{(optional) Logical: if TRUE, the creation of a BigTIFF is
forced (default is FALSE).
This option is used only in the case a GeoTIFF format was chosen.}

\item{overwrite}{Logical value: should existing output files be
overwritten? (default: FALSE)}
}
\value{
A vector with the names of the created output files
(just created or already existing).
}
\description{
The function extracts sun angle rasters from
a SAFE archive, reshaping the original information (5 km resolution)
to the desired Sentinel-2 output resolution.
It was not exported because it is intended to be called by \link{s2_translate}.
}
\note{
License: GPL 3.0
}
\examples{
\dontrun{

s2_l2a_example <- file.path(
  "/existing/path",
  "S2B_MSIL2A_20200801T100559_N0214_R022_T32TNR_20200801T135302.SAFE"
)

# Create all products
s2_angles(s2_l2a_example, outdir = tempdir())

# Create only Viewing Incidence Angles at Azimuth, at 60 m resolution,
# with cubic interpolation, in ENVI format
s2_angles(
  s2_l2a_example, 
  outdir = tempdir(), 
  prod_type = "OAA", 
  res = "60m",
  method = "cubic",
  format = "ENVI"
)
}
}
\references{
L. Ranghetti, M. Boschetti, F. Nutini, L. Busetto (2020).
"sen2r": An R toolbox for automatically downloading and preprocessing
Sentinel-2 satellite data. \emph{Computers & Geosciences}, 139, 104473.
\doi{10.1016/j.cageo.2020.104473}, URL: \url{https://sen2r.ranghetti.info/}.
}
\author{
Luigi Ranghetti, phD (2022) \email{luigi@ranghetti.info}

Marina Ranghetti (2022)
}
\keyword{internal}
